/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor.scope;

import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor0;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;

public class ScopedInterceptor0
implements AroundInterceptor0 {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean debugEnabled = this.logger.isDebugEnabled();
    private final AroundInterceptor0 interceptor;
    private final InterceptorScope scope;
    private final ExecutionPolicy policy;

    public ScopedInterceptor0(AroundInterceptor0 interceptor, InterceptorScope scope, ExecutionPolicy policy) {
        if (interceptor == null) {
            throw new NullPointerException("interceptor must not be null");
        }
        if (scope == null) {
            throw new NullPointerException("scope must not be null");
        }
        if (policy == null) {
            throw new NullPointerException("policy must not be null");
        }
        this.interceptor = interceptor;
        this.scope = scope;
        this.policy = policy;
    }

    @Override
    public void before(Object target) {
        InterceptorScopeInvocation transaction = this.scope.getCurrentInvocation();
        if (transaction.tryEnter(this.policy)) {
            this.interceptor.before(target);
        } else if (this.debugEnabled) {
            this.logger.debug("tryBefore() returns false: interceptorScopeTransaction: {}, executionPoint: {}. Skip interceptor {}", new Object[]{transaction, this.policy, this.interceptor.getClass()});
        }
    }

    @Override
    public void after(Object target, Object result, Throwable throwable) {
        InterceptorScopeInvocation transaction = this.scope.getCurrentInvocation();
        if (transaction.canLeave(this.policy)) {
            this.interceptor.after(target, result, throwable);
            transaction.leave(this.policy);
        } else if (this.debugEnabled) {
            this.logger.debug("tryAfter() returns false: interceptorScopeTransaction: {}, executionPoint: {}. Skip interceptor {}", new Object[]{transaction, this.policy, this.interceptor.getClass()});
        }
    }
}

