/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.sender.UdpSocketAddressProvider;
import com.navercorp.pinpoint.rpc.client.SocketAddressProvider;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshStrategy
implements UdpSocketAddressProvider {
    public static final long DEFAULT_PORT_UNREACHABLE_REFRESH_DELAY = TimeUnit.SECONDS.toMillis(30L);
    public static final long NORMAL_REFRESH_DELAY = TimeUnit.MINUTES.toMillis(5L);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SocketAddressProvider socketAddressProvider;
    private final long normalRefreshDelay;
    private final long portUnreachableRefreshDelay;
    private InetSocketAddress socketAddress;
    private long lastRefreshTime;
    private boolean portUnreachableState = false;

    public RefreshStrategy(SocketAddressProvider socketAddressProvider) {
        this(socketAddressProvider, NORMAL_REFRESH_DELAY, DEFAULT_PORT_UNREACHABLE_REFRESH_DELAY);
    }

    public RefreshStrategy(SocketAddressProvider socketAddressProvider, long normalRefreshDelay, long portUnreachableRefreshDelay) {
        this.socketAddressProvider = (SocketAddressProvider)Assert.requireNonNull((Object)socketAddressProvider, (String)"socketAddressProvider must not be null");
        this.normalRefreshDelay = normalRefreshDelay;
        this.portUnreachableRefreshDelay = portUnreachableRefreshDelay;
    }

    @Override
    public void handlePortUnreachable() {
        this.portUnreachableState = true;
    }

    public InetSocketAddress resolve() {
        InetSocketAddress newAddress;
        boolean refresh = this.needRefresh();
        if (refresh && this.isResolved(newAddress = this.socketAddressProvider.resolve())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("DNS refresh {}", (Object)newAddress);
            }
            this.socketAddress = newAddress;
        }
        return this.socketAddress;
    }

    public boolean isResolved(InetSocketAddress newAddress) {
        if (newAddress == null) {
            return false;
        }
        return !newAddress.isUnresolved();
    }

    private boolean needRefresh() {
        boolean portUnreachableStatus = this.resetPortUnreachableState();
        long deadline = this.getDeadline(portUnreachableStatus);
        long currentTimeMillis = this.tick();
        if (currentTimeMillis > deadline) {
            this.lastRefreshTime = currentTimeMillis;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    long tick() {
        return System.currentTimeMillis();
    }

    private long getDeadline(boolean portUnreachableStatus) {
        if (portUnreachableStatus) {
            return this.lastRefreshTime + this.portUnreachableRefreshDelay;
        }
        return this.lastRefreshTime + this.normalRefreshDelay;
    }

    private boolean resetPortUnreachableState() {
        boolean currentState = this.portUnreachableState;
        this.portUnreachableState = false;
        return currentState;
    }
}

