/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.cassandra.interceptor;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DefaultDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.util.InterceptorUtils;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.cassandra.CassandraConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CassandraDriverConnectInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    private final boolean recordConnection;

    public CassandraDriverConnectInterceptor(TraceContext context, MethodDescriptor descriptor) {
        this(context, descriptor, true);
    }

    public CassandraDriverConnectInterceptor(TraceContext context, MethodDescriptor descriptor, boolean recordConnection) {
        super(context, descriptor);
        this.recordConnection = recordConnection;
    }

    protected void logBeforeInterceptor(Object target, Object[] args) {
        this.logger.beforeInterceptor(target, null);
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
    }

    protected void logAfterInterceptor(Object target, Object[] args, Object result, Throwable throwable) {
        this.logger.afterInterceptor(target, null, result, throwable);
    }

    protected void prepareAfterTrace(Object target, Object[] args, Object result, Throwable throwable) {
        boolean success = InterceptorUtils.isSuccess((Throwable)throwable);
        List<String> hostList = this.getHostList(target);
        if (args == null) {
            return;
        }
        String keyspace = (String)args[0];
        DatabaseInfo databaseInfo = this.createDatabaseInfo(keyspace, hostList);
        if (success && this.recordConnection && result instanceof DatabaseInfoAccessor) {
            ((DatabaseInfoAccessor)result)._$PINPOINT$_setDatabaseInfo(databaseInfo);
        }
    }

    private List<String> getHostList(Object target) {
        if (!(target instanceof Cluster)) {
            return Collections.emptyList();
        }
        Cluster cluster = (Cluster)target;
        Set hosts = cluster.getMetadata().getAllHosts();
        int port = cluster.getConfiguration().getProtocolOptions().getPort();
        ArrayList<String> hostList = new ArrayList<String>();
        for (Host host : hosts) {
            String hostAddress = HostAndPort.toHostAndPortString((String)host.getAddress().getHostAddress(), (int)port);
            hostList.add(hostAddress);
        }
        return hostList;
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        if (this.recordConnection) {
            DatabaseInfo databaseInfo = result instanceof DatabaseInfoAccessor ? ((DatabaseInfoAccessor)result)._$PINPOINT$_getDatabaseInfo() : null;
            if (databaseInfo == null) {
                databaseInfo = UnKnownDatabaseInfo.INSTANCE;
            }
            recorder.recordServiceType(databaseInfo.getType());
            recorder.recordEndPoint(databaseInfo.getMultipleHost());
            recorder.recordDestinationId(databaseInfo.getDatabaseId());
        }
        recorder.recordApi(this.methodDescriptor);
        recorder.recordException(throwable);
    }

    private DatabaseInfo createDatabaseInfo(String keyspace, List<String> hostList) {
        if (keyspace == null) {
            return UnKnownDatabaseInfo.INSTANCE;
        }
        DefaultDatabaseInfo databaseInfo = new DefaultDatabaseInfo(CassandraConstants.CASSANDRA, CassandraConstants.CASSANDRA_EXECUTE_QUERY, null, null, hostList, keyspace);
        if (this.isDebug) {
            this.logger.debug("parse DatabaseInfo:{}", (Object)databaseInfo);
        }
        return databaseInfo;
    }
}

