/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.undertow.interceptor;

import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.util.SocketAddressUtils;
import com.navercorp.pinpoint.bootstrap.util.NetworkUtils;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import java.net.InetSocketAddress;

public class HttpServerExchangeAdaptor
implements RequestAdaptor<HttpServerExchange> {
    public String getHeader(HttpServerExchange request, String name) {
        HeaderValues values = request.getRequestHeaders().get(name);
        if (values != null) {
            return values.peekFirst();
        }
        return null;
    }

    public String getRpcName(HttpServerExchange request) {
        return request.getRequestURI();
    }

    public String getEndPoint(HttpServerExchange request) {
        InetSocketAddress address = request.getDestinationAddress();
        if (address != null) {
            return HostAndPort.toHostAndPortString((String)SocketAddressUtils.getHostNameFirst((InetSocketAddress)address), (int)address.getPort());
        }
        return "Unknown";
    }

    public String getRemoteAddress(HttpServerExchange request) {
        InetSocketAddress address = request.getSourceAddress();
        if (address != null) {
            return SocketAddressUtils.getAddressFirst((InetSocketAddress)address);
        }
        return null;
    }

    public String getAcceptorHost(HttpServerExchange request) {
        return NetworkUtils.getHostFromURL((String)request.getRequestURI());
    }
}

