/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.util;

import com.navercorp.pinpoint.common.util.IOUtils;
import com.navercorp.pinpoint.profiler.util.FileBinary;
import com.navercorp.pinpoint.profiler.util.JarEntryFilter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarReader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int BUFFER_SIZE = 4096;
    private final JarFile jarFile;

    public JarReader(JarFile jarFile) {
        if (jarFile == null) {
            throw new NullPointerException("jarFile must not be null");
        }
        this.jarFile = jarFile;
    }

    public InputStream getInputStream(String name) throws IOException {
        JarEntry jarEntry = this.jarFile.getJarEntry(name);
        if (jarEntry != null) {
            return this.jarFile.getInputStream(jarEntry);
        }
        return null;
    }

    public List<FileBinary> read(JarEntryFilter jarEntryFilter) throws IOException {
        if (jarEntryFilter == null) {
            throw new NullPointerException("jarEntryFilter must not be null");
        }
        BufferedContext bufferedContext = new BufferedContext();
        Enumeration<JarEntry> entries = this.jarFile.entries();
        ArrayList<FileBinary> fileBinaryList = new ArrayList<FileBinary>();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (!jarEntryFilter.filter(jarEntry)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("filter fileName:{}, JarFile:{}", (Object)jarEntry, (Object)this.jarFile.getName());
            }
            FileBinary fileBinary = this.newFileBinary(bufferedContext, jarEntry);
            fileBinaryList.add(fileBinary);
        }
        return fileBinaryList;
    }

    private FileBinary newFileBinary(BufferedContext bufferedContext, JarEntry jarEntry) throws IOException {
        byte[] binary = bufferedContext.read(jarEntry);
        FileBinary fileBinary = new FileBinary(jarEntry.getName(), binary);
        return fileBinary;
    }

    private class BufferedContext {
        private final byte[] buffer = new byte[4096];
        private final ByteArrayOutputStream output = new ByteArrayOutputStream(4096);

        private BufferedContext() {
        }

        private byte[] read(JarEntry jarEntry) throws IOException {
            byte[] byArray;
            InputStream inputStream;
            block5: {
                inputStream = null;
                inputStream = JarReader.this.jarFile.getInputStream(jarEntry);
                if (inputStream != null) break block5;
                JarReader.this.logger.warn("jarEntry not found. jarFile:{} jarEntry{}", (Object)JarReader.this.jarFile.getName(), (Object)jarEntry);
                byte[] byArray2 = null;
                IOUtils.closeQuietly((Closeable)inputStream);
                return byArray2;
            }
            try {
                byArray = this.read(inputStream);
            }
            catch (IOException ioe) {
                try {
                    JarReader.this.logger.warn("jarFile read error jarFile:{} jarEntry{} {}", new Object[]{JarReader.this.jarFile.getName(), jarEntry, ioe.getMessage(), ioe});
                    throw ioe;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)inputStream);
            return byArray;
        }

        public byte[] read(InputStream input) throws IOException {
            this.output.reset();
            IOUtils.copy((InputStream)input, (OutputStream)this.output, (byte[])this.buffer);
            return this.output.toByteArray();
        }
    }
}

