/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.server;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.rpc.ChannelWriteFailListenableFuture;
import com.navercorp.pinpoint.rpc.Future;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.rpc.client.RequestManager;
import com.navercorp.pinpoint.rpc.client.WriteFailFutureListener;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;
import com.navercorp.pinpoint.rpc.cluster.Role;
import com.navercorp.pinpoint.rpc.common.CyclicStateChecker;
import com.navercorp.pinpoint.rpc.common.SocketStateChangeResult;
import com.navercorp.pinpoint.rpc.common.SocketStateCode;
import com.navercorp.pinpoint.rpc.control.ProtocolException;
import com.navercorp.pinpoint.rpc.packet.ControlHandshakePacket;
import com.navercorp.pinpoint.rpc.packet.ControlHandshakeResponsePacket;
import com.navercorp.pinpoint.rpc.packet.HandshakeResponseCode;
import com.navercorp.pinpoint.rpc.packet.Packet;
import com.navercorp.pinpoint.rpc.packet.PingPacket;
import com.navercorp.pinpoint.rpc.packet.PingPayloadPacket;
import com.navercorp.pinpoint.rpc.packet.PongPacket;
import com.navercorp.pinpoint.rpc.packet.RequestPacket;
import com.navercorp.pinpoint.rpc.packet.ResponsePacket;
import com.navercorp.pinpoint.rpc.packet.SendPacket;
import com.navercorp.pinpoint.rpc.packet.ServerClosePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPacket;
import com.navercorp.pinpoint.rpc.server.DefaultPinpointServerState;
import com.navercorp.pinpoint.rpc.server.HealthCheckState;
import com.navercorp.pinpoint.rpc.server.HealthCheckStateContext;
import com.navercorp.pinpoint.rpc.server.PinpointServer;
import com.navercorp.pinpoint.rpc.server.PinpointServerConfig;
import com.navercorp.pinpoint.rpc.server.ServerMessageListener;
import com.navercorp.pinpoint.rpc.server.handler.DoNothingChannelStateEventHandler;
import com.navercorp.pinpoint.rpc.server.handler.ServerStateChangeEventHandler;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannel;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannelContext;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannelMessageListener;
import com.navercorp.pinpoint.rpc.stream.StreamChannelContext;
import com.navercorp.pinpoint.rpc.stream.StreamChannelManager;
import com.navercorp.pinpoint.rpc.stream.StreamChannelStateChangeEventHandler;
import com.navercorp.pinpoint.rpc.util.ClassUtils;
import com.navercorp.pinpoint.rpc.util.ControlMessageEncodingUtils;
import com.navercorp.pinpoint.rpc.util.IDGenerator;
import com.navercorp.pinpoint.rpc.util.ListUtils;
import com.navercorp.pinpoint.rpc.util.MapUtils;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPinpointServer
implements PinpointServer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final long startTimestamp = System.currentTimeMillis();
    private final Channel channel;
    private final RequestManager requestManager;
    private final DefaultPinpointServerState state;
    private final CyclicStateChecker stateChecker;
    private HealthCheckStateContext healthCheckStateContext = new HealthCheckStateContext();
    private final ServerMessageListener messageListener;
    private final List<ServerStateChangeEventHandler> stateChangeEventListeners;
    private final StreamChannelManager streamChannelManager;
    private final AtomicReference<Map<Object, Object>> properties = new AtomicReference();
    private final String objectUniqName;
    private final ClusterOption localClusterOption;
    private ClusterOption remoteClusterOption;
    private final ChannelFutureListener serverCloseWriteListener;
    private final ChannelFutureListener responseWriteFailListener;
    private final WriteFailFutureListener pongWriteFutureListener = new WriteFailFutureListener(this.logger, "pong write fail.", "pong write success.");

    public DefaultPinpointServer(Channel channel, PinpointServerConfig serverConfig) {
        this(channel, serverConfig, null);
    }

    public DefaultPinpointServer(Channel channel, PinpointServerConfig serverConfig, ServerStateChangeEventHandler ... stateChangeEventListeners) {
        RequestManager requestManager;
        StreamChannelManager streamChannelManager;
        this.channel = channel;
        this.messageListener = serverConfig.getMessageListener();
        this.streamChannelManager = streamChannelManager = new StreamChannelManager(channel, IDGenerator.createEvenIdGenerator(), serverConfig.getStreamMessageListener());
        this.stateChangeEventListeners = new ArrayList<ServerStateChangeEventHandler>();
        List<ServerStateChangeEventHandler> configuredStateChangeEventHandlers = serverConfig.getStateChangeEventHandlers();
        if (configuredStateChangeEventHandlers != null) {
            for (ServerStateChangeEventHandler configuredStateChangeEventHandler : configuredStateChangeEventHandlers) {
                ListUtils.addIfValueNotNull(this.stateChangeEventListeners, configuredStateChangeEventHandler);
            }
        }
        ListUtils.addAllExceptNullValue(this.stateChangeEventListeners, stateChangeEventListeners);
        if (this.stateChangeEventListeners.isEmpty()) {
            this.stateChangeEventListeners.add(DoNothingChannelStateEventHandler.INSTANCE);
        }
        this.requestManager = requestManager = new RequestManager(serverConfig.getRequestManagerTimer(), serverConfig.getDefaultRequestTimeout());
        this.objectUniqName = ClassUtils.simpleClassNameAndHashCodeString(this);
        this.serverCloseWriteListener = new WriteFailFutureListener(this.logger, this.objectUniqName + " sendClosePacket() write fail.", "serverClosePacket write success");
        this.responseWriteFailListener = new WriteFailFutureListener(this.logger, this.objectUniqName + " response() write fail.");
        this.state = new DefaultPinpointServerState(this, this.stateChangeEventListeners);
        this.stateChecker = new CyclicStateChecker(5);
        this.localClusterOption = serverConfig.getClusterOption();
    }

    public void start() {
        this.logger.info("{} start() started. channel:{}.", (Object)this.objectUniqName, (Object)this.channel);
        this.state.toConnected();
        this.state.toRunWithoutHandshake();
        this.logger.info("{} start() completed.", (Object)this.objectUniqName);
    }

    public void stop() {
        this.logger.info("{} stop() started. channel:{}.", (Object)this.objectUniqName, (Object)this.channel);
        this.stop(false);
        this.logger.info("{} stop() completed.", (Object)this.objectUniqName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean serverStop) {
        try {
            SocketStateCode currentStateCode = this.getCurrentStateCode();
            if (SocketStateCode.BEING_CLOSE_BY_SERVER == currentStateCode) {
                this.state.toClosed();
            } else if (SocketStateCode.BEING_CLOSE_BY_CLIENT == currentStateCode) {
                this.state.toClosedByPeer();
            } else if (SocketStateCode.isRun(currentStateCode) && serverStop) {
                this.state.toUnexpectedClosed();
            } else if (SocketStateCode.isRun(currentStateCode)) {
                this.state.toUnexpectedClosedByPeer();
            } else if (SocketStateCode.isClosed(currentStateCode)) {
                this.logger.warn("{} stop(). Socket has closed state({}).", (Object)this.objectUniqName, (Object)currentStateCode);
            } else {
                this.state.toErrorUnknown();
                this.logger.warn("{} stop(). Socket has unexpected state.", (Object)this.objectUniqName, (Object)currentStateCode);
            }
            if (this.channel.isConnected()) {
                this.channel.close();
            }
        }
        finally {
            this.streamChannelManager.close();
        }
    }

    @Override
    public void send(byte[] payload) {
        Assert.requireNonNull((Object)payload, (String)"payload must not be null.");
        if (!this.isEnableDuplexCommunication()) {
            throw new IllegalStateException("Send fail. Error: Illegal State. pinpointServer:" + this.toString());
        }
        SendPacket send = new SendPacket(payload);
        this.write0(send);
    }

    @Override
    public Future<ResponseMessage> request(byte[] payload) {
        Assert.requireNonNull((Object)payload, (String)"payload must not be null.");
        if (!this.isEnableDuplexCommunication()) {
            throw new IllegalStateException("Request fail. Error: Illegal State. pinpointServer:" + this.toString());
        }
        int requestId = this.requestManager.nextRequestId();
        RequestPacket requestPacket = new RequestPacket(requestId, payload);
        ChannelWriteFailListenableFuture<ResponseMessage> responseFuture = this.requestManager.register(requestPacket.getRequestId());
        this.write0(requestPacket, responseFuture);
        return responseFuture;
    }

    @Override
    public void response(int requestId, byte[] payload) {
        Assert.requireNonNull((Object)payload, (String)"payload must not be null.");
        if (!this.isEnableCommunication()) {
            throw new IllegalStateException("Response fail. Error: Illegal State. pinpointServer:" + this.toString());
        }
        ResponsePacket responsePacket = new ResponsePacket(requestId, payload);
        this.write0(responsePacket, this.responseWriteFailListener);
    }

    private ChannelFuture write0(Object message) {
        return this.write0(message, null);
    }

    private ChannelFuture write0(Object message, ChannelFutureListener futureListener) {
        ChannelFuture future = this.channel.write(message);
        if (futureListener != null) {
            future.addListener(futureListener);
        }
        return future;
    }

    public StreamChannelContext getStreamChannel(int channelId) {
        return this.streamChannelManager.findStreamChannel(channelId);
    }

    @Override
    public ClientStreamChannelContext openStream(byte[] payload, ClientStreamChannelMessageListener messageListener) {
        return this.openStream(payload, messageListener, null);
    }

    @Override
    public ClientStreamChannelContext openStream(byte[] payload, ClientStreamChannelMessageListener messageListener, StreamChannelStateChangeEventHandler<ClientStreamChannel> stateChangeListener) {
        this.logger.info("{} createStream() started.", (Object)this.objectUniqName);
        ClientStreamChannelContext streamChannel = this.streamChannelManager.openStream(payload, messageListener, stateChangeListener);
        this.logger.info("{} createStream() completed.", (Object)this.objectUniqName);
        return streamChannel;
    }

    public void closeAllStreamChannel() {
        this.logger.info("{} closeAllStreamChannel() started.", (Object)this.objectUniqName);
        this.streamChannelManager.close();
        this.logger.info("{} closeAllStreamChannel() completed.", (Object)this.objectUniqName);
    }

    @Override
    public Map<Object, Object> getChannelProperties() {
        Map<Object, Object> properties = this.properties.get();
        return properties == null ? Collections.emptyMap() : properties;
    }

    public boolean setChannelProperties(Map<Object, Object> value) {
        if (value == null) {
            return false;
        }
        return this.properties.compareAndSet(null, Collections.unmodifiableMap(value));
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    public ChannelFuture sendClosePacket() {
        this.logger.info("{} sendClosePacket() started.", (Object)this.objectUniqName);
        SocketStateChangeResult stateChangeResult = this.state.toBeingClose();
        if (stateChangeResult.isChange()) {
            ChannelFuture writeFuture = this.write0(ServerClosePacket.DEFAULT_SERVER_CLOSE_PACKET, this.serverCloseWriteListener);
            this.logger.info("{} sendClosePacket() completed.", (Object)this.objectUniqName);
            return writeFuture;
        }
        this.logger.info("{} sendClosePacket() failed. Error:{}.", (Object)this.objectUniqName, (Object)stateChangeResult);
        return null;
    }

    @Override
    public void messageReceived(Object message) {
        if (!this.isEnableCommunication()) {
            this.logger.warn("{} messageReceived() failed. Error: Illegal state this message({}) will be ignore.", (Object)this.objectUniqName, message);
            return;
        }
        short packetType = this.getPacketType(message);
        switch (packetType) {
            case 1: {
                this.handleSend((SendPacket)message);
                return;
            }
            case 5: {
                this.handleRequest((RequestPacket)message);
                return;
            }
            case 6: {
                this.handleResponse((ResponsePacket)message);
                return;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                this.handleStreamEvent((StreamPacket)message);
                return;
            }
            case 150: {
                this.handleHandshake((ControlHandshakePacket)message);
                return;
            }
            case 100: {
                this.handleClosePacket(this.channel);
                return;
            }
            case 211: {
                this.handlePingPacket(this.channel, (PingPayloadPacket)message);
                return;
            }
            case 200: {
                this.handlePingPacket(this.channel, (PingPacket)message);
                return;
            }
        }
        this.logger.warn("invalid messageReceived msg:{}, connection:{}", message, (Object)this.channel);
    }

    private short getPacketType(Object packet) {
        if (packet == null) {
            return 500;
        }
        if (packet instanceof Packet) {
            return ((Packet)packet).getPacketType();
        }
        return 500;
    }

    private void handleSend(SendPacket sendPacket) {
        this.messageListener.handleSend(sendPacket, this);
    }

    private void handleRequest(RequestPacket requestPacket) {
        this.messageListener.handleRequest(requestPacket, this);
    }

    private void handleResponse(ResponsePacket responsePacket) {
        this.requestManager.messageReceived(responsePacket, this);
    }

    private void handleStreamEvent(StreamPacket streamPacket) {
        this.streamChannelManager.messageReceived(streamPacket);
    }

    private void handleHandshake(ControlHandshakePacket handshakePacket) {
        int requestId = handshakePacket.getRequestId();
        Map<Object, Object> handshakeData = this.decodeHandshakePacket(handshakePacket);
        this.logger.info("{} handleHandshake() started. requestId:{}, data:{}", new Object[]{this.objectUniqName, requestId, handshakeData});
        HandshakeResponseCode responseCode = this.messageListener.handleHandshake(handshakeData);
        if (responseCode != null) {
            boolean isFirst = this.setChannelProperties(handshakeData);
            if (isFirst) {
                if (HandshakeResponseCode.DUPLEX_COMMUNICATION == responseCode) {
                    this.remoteClusterOption = this.getClusterOption(handshakeData);
                    this.state.toRunDuplex();
                } else if (HandshakeResponseCode.SIMPLEX_COMMUNICATION == responseCode || HandshakeResponseCode.SUCCESS == responseCode) {
                    this.state.toRunSimplex();
                }
            }
            Map<String, Object> responseData = this.createHandshakeResponse(responseCode, isFirst);
            this.sendHandshakeResponse0(requestId, responseData);
            this.logger.info("{} handleHandshake() completed(isFirst:{}). requestId:{}, responseCode:{}", new Object[]{this.objectUniqName, isFirst, requestId, responseCode});
        } else {
            this.logger.info("{} to execute handleHandshake() is not ready", (Object)this.objectUniqName);
        }
    }

    private ClusterOption getClusterOption(Map handshakeResponse) {
        if (handshakeResponse == Collections.EMPTY_MAP) {
            return ClusterOption.DISABLE_CLUSTER_OPTION;
        }
        Map cluster = (Map)handshakeResponse.get("cluster");
        if (cluster == null) {
            return ClusterOption.DISABLE_CLUSTER_OPTION;
        }
        String id = MapUtils.getString(cluster, "id", "");
        List<Role> roles = this.getRoles((List)cluster.get("roles"));
        if (StringUtils.isEmpty((String)id)) {
            return ClusterOption.DISABLE_CLUSTER_OPTION;
        }
        return new ClusterOption(true, id, roles);
    }

    private List<Role> getRoles(List roleNames) {
        ArrayList<Role> roles = new ArrayList<Role>();
        for (Object roleName : roleNames) {
            if (!(roleName instanceof String) || !StringUtils.hasLength((String)((String)roleName))) continue;
            roles.add(Role.getValue((String)roleName));
        }
        return roles;
    }

    private void handleClosePacket(Channel channel) {
        this.logger.info("{} handleClosePacket() started.", (Object)this.objectUniqName);
        SocketStateChangeResult stateChangeResult = this.state.toBeingCloseByPeer();
        if (!stateChangeResult.isChange()) {
            this.logger.info("{} handleClosePacket() failed. Error: {}", (Object)this.objectUniqName, (Object)stateChangeResult);
        } else {
            this.logger.info("{} handleClosePacket() completed.", (Object)this.objectUniqName);
        }
    }

    private void handlePingPacket(Channel channel, PingPacket packet) {
        this.logger.debug("{} handleLegacyPingPacket() started. packet:{}", (Object)this.objectUniqName, (Object)packet);
        if (this.healthCheckStateContext.getState() == HealthCheckState.WAIT) {
            this.healthCheckStateContext.toReceivedLegacy();
        }
        if (packet == PingPacket.PING_PACKET) {
            this.writePong(channel);
            return;
        }
        PingPayloadPacket pingPayloadPacket = new PingPayloadPacket(packet.getPingId(), packet.getStateVersion(), packet.getStateCode());
        this.handlePingPacket0(channel, pingPayloadPacket);
    }

    private void handlePingPacket(Channel channel, PingPayloadPacket packet) {
        this.logger.debug("{} handlePingPacket() started. packet:{}", (Object)this.objectUniqName, (Object)packet);
        if (this.healthCheckStateContext.getState() == HealthCheckState.WAIT) {
            this.healthCheckStateContext.toReceived();
        }
        this.handlePingPacket0(channel, packet);
    }

    private void handlePingPacket0(Channel channel, PingPayloadPacket packet) {
        SocketStateCode statusCode = this.state.getCurrentStateCode();
        if (statusCode.getId() == packet.getStateCode()) {
            this.stateChecker.unmark();
            this.messageListener.handlePing(packet, this);
            this.writePong(channel);
        } else {
            this.logger.warn("Session state sync failed. channel:{}, packet:{}, server-state:{}", new Object[]{channel, packet, statusCode});
            if (this.stateChecker.markAndCheckCondition()) {
                this.state.toErrorSyncStateSession();
                this.stop();
            } else {
                this.writePong(channel);
            }
        }
    }

    private void writePong(Channel channel) {
        this.write0(PongPacket.PONG_PACKET, this.pongWriteFutureListener);
    }

    private Map<String, Object> createHandshakeResponse(HandshakeResponseCode responseCode, boolean isFirst) {
        HandshakeResponseCode createdCode = this.getHandshakeResponseCode(responseCode, isFirst);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", createdCode.getCode());
        result.put("subCode", createdCode.getSubCode());
        if (this.localClusterOption.isEnable()) {
            Map<String, Object> clusterOption = this.localClusterOption.toMap();
            result.put("cluster", clusterOption);
        }
        return result;
    }

    private HandshakeResponseCode getHandshakeResponseCode(HandshakeResponseCode responseCode, boolean isFirst) {
        if (isFirst) {
            return responseCode;
        }
        if (HandshakeResponseCode.DUPLEX_COMMUNICATION == responseCode) {
            return HandshakeResponseCode.ALREADY_DUPLEX_COMMUNICATION;
        }
        if (HandshakeResponseCode.SIMPLEX_COMMUNICATION == responseCode) {
            return HandshakeResponseCode.ALREADY_SIMPLEX_COMMUNICATION;
        }
        return responseCode;
    }

    private void sendHandshakeResponse0(int requestId, Map<String, Object> data) {
        try {
            byte[] resultPayload = ControlMessageEncodingUtils.encode(data);
            ControlHandshakeResponsePacket packet = new ControlHandshakeResponsePacket(requestId, resultPayload);
            this.write0(packet);
        }
        catch (ProtocolException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private Map<Object, Object> decodeHandshakePacket(ControlHandshakePacket message) {
        try {
            byte[] payload = message.getPayload();
            Map properties = (Map)ControlMessageEncodingUtils.decode(payload);
            return properties;
        }
        catch (ProtocolException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public boolean isEnableCommunication() {
        return this.state.isEnableCommunication();
    }

    public boolean isEnableDuplexCommunication() {
        return this.state.isEnableDuplexCommunication();
    }

    String getObjectUniqName() {
        return this.objectUniqName;
    }

    @Override
    public ClusterOption getLocalClusterOption() {
        return this.localClusterOption;
    }

    @Override
    public ClusterOption getRemoteClusterOption() {
        return this.remoteClusterOption;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public HealthCheckState getHealthCheckState() {
        return this.healthCheckStateContext.getState();
    }

    @Override
    public SocketStateCode getCurrentStateCode() {
        return this.state.getCurrentStateCode();
    }

    @Override
    public void close() {
        this.stop();
    }

    public String toString() {
        StringBuilder log = new StringBuilder(32);
        log.append(this.objectUniqName);
        log.append("(");
        log.append("remote:");
        log.append(this.getRemoteAddress());
        log.append(", state:");
        log.append((Object)this.getCurrentStateCode());
        log.append(", healthCheckState:");
        log.append((Object)this.getHealthCheckState());
        log.append(")");
        return log.toString();
    }
}

