/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.util;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.JvmUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public final class SocketAddressUtils {
    private static final PLogger LOGGER = PLoggerFactory.getLogger(SocketAddressUtils.class);
    private static final HostStringAccessor HOST_STRING_ACCESSOR = SocketAddressUtils.createHostStringAccessor();

    private static HostStringAccessor createHostStringAccessor() {
        try {
            Method m = InetSocketAddress.class.getDeclaredMethod("getHostString", new Class[0]);
            m.setAccessible(true);
            return new ReflectiveHostStringAccessor(m);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("[{}] {} - getHostString() not present in class InetSocketAddress.", (Object)JvmUtils.getType(), (Object)JvmUtils.getVersion());
            throw new IllegalStateException("Unexpected InetSocketAddress class", e);
        }
    }

    private SocketAddressUtils() {
    }

    public static String getHostNameFirst(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            return null;
        }
        return HOST_STRING_ACCESSOR.getHostString(inetSocketAddress);
    }

    public static String getHostNameFirst(InetSocketAddress inetSocketAddress, String defaultHostName) {
        String hostName = SocketAddressUtils.getHostNameFirst(inetSocketAddress);
        if (hostName == null) {
            return defaultHostName;
        }
        return hostName;
    }

    public static String getAddressFirst(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            return null;
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress != null) {
            return inetAddress.getHostAddress();
        }
        return inetSocketAddress.getHostName();
    }

    public static String getAddressFirst(InetSocketAddress inetSocketAddress, String defaultAddress) {
        String address = SocketAddressUtils.getAddressFirst(inetSocketAddress);
        if (address == null) {
            return defaultAddress;
        }
        return address;
    }

    private static class ReflectiveHostStringAccessor
    implements HostStringAccessor {
        private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
        private final Method method;

        private ReflectiveHostStringAccessor(Method method) {
            if (method == null) {
                throw new NullPointerException("method must not be null");
            }
            this.method = method;
        }

        @Override
        public String getHostString(InetSocketAddress inetSocketAddress) {
            try {
                return (String)this.method.invoke((Object)inetSocketAddress, new Object[0]);
            }
            catch (IllegalAccessException e) {
                this.logger.error("[{}] {} - Cannot access method : {}", JvmUtils.getType(), JvmUtils.getVersion(), this.method.getName(), e);
            }
            catch (InvocationTargetException e) {
                this.logger.error("[{}] {} - Error invoking method : {}", JvmUtils.getType(), JvmUtils.getVersion(), this.method.getName(), e);
            }
            catch (Exception e) {
                this.logger.error("[{}] {} - Unexpected error retrieving hostString", JvmUtils.getType(), JvmUtils.getVersion(), e);
            }
            return null;
        }
    }

    private static interface HostStringAccessor {
        public String getHostString(InetSocketAddress var1);
    }
}

