/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.module;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.navercorp.pinpoint.bootstrap.AgentOption;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.bootstrap.module.ClassFileTransformModuleAdaptor;
import com.navercorp.pinpoint.bootstrap.module.JavaModuleFactory;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.profiler.AgentInfoSender;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.context.ServerMetaDataRegistryService;
import com.navercorp.pinpoint.profiler.context.javamodule.ClassFileTransformerModuleHandler;
import com.navercorp.pinpoint.profiler.context.javamodule.JavaModuleFactoryFinder;
import com.navercorp.pinpoint.profiler.context.module.ApplicationContext;
import com.navercorp.pinpoint.profiler.context.module.DefaultClientFactory;
import com.navercorp.pinpoint.profiler.context.module.ModuleFactory;
import com.navercorp.pinpoint.profiler.context.module.SpanClientFactory;
import com.navercorp.pinpoint.profiler.context.module.SpanDataSender;
import com.navercorp.pinpoint.profiler.context.module.SpanStatChannelFactory;
import com.navercorp.pinpoint.profiler.context.module.SpanStatConnectTimer;
import com.navercorp.pinpoint.profiler.context.module.StatClientFactory;
import com.navercorp.pinpoint.profiler.context.module.StatDataSender;
import com.navercorp.pinpoint.profiler.instrument.BytecodeDumpTransformer;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.lambda.LambdaTransformBootloader;
import com.navercorp.pinpoint.profiler.interceptor.registry.InterceptorRegistryBinder;
import com.navercorp.pinpoint.profiler.monitor.AgentStatMonitor;
import com.navercorp.pinpoint.profiler.monitor.DeadlockMonitor;
import com.navercorp.pinpoint.profiler.receiver.CommandDispatcher;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.EnhancedDataSender;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.util.Set;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationContext
implements ApplicationContext {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;
    private final DeadlockMonitor deadlockMonitor;
    private final AgentInfoSender agentInfoSender;
    private final AgentStatMonitor agentStatMonitor;
    private final TraceContext traceContext;
    private final CommandDispatcher commandDispatcher;
    private final PinpointClientFactory clientFactory;
    private final EnhancedDataSender tcpDataSender;
    private final Timer spanStatConnectTimer;
    private final ChannelFactory spanStatChannelFactory;
    private final PinpointClientFactory spanClientFactory;
    private final PinpointClientFactory statClientFactory;
    private final DataSender spanDataSender;
    private final DataSender statDataSender;
    private final AgentInformation agentInformation;
    private final ServerMetaDataRegistryService serverMetaDataRegistryService;
    private final ClassFileTransformer classFileTransformer;
    private final InstrumentEngine instrumentEngine;
    private final DynamicTransformTrigger dynamicTransformTrigger;
    private final InterceptorRegistryBinder interceptorRegistryBinder;
    private final Injector injector;

    public DefaultApplicationContext(AgentOption agentOption, ModuleFactory moduleFactory) {
        Assert.requireNonNull((Object)agentOption, (String)"agentOption must not be null");
        Assert.requireNonNull((Object)moduleFactory, (String)"moduleFactory must not be null");
        Assert.requireNonNull((Object)agentOption.getProfilerConfig(), (String)"profilerConfig must not be null");
        Instrumentation instrumentation = agentOption.getInstrumentation();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("DefaultAgent classLoader:{}", (Object)this.getClass().getClassLoader());
        }
        Module applicationContextModule = moduleFactory.newModule(agentOption);
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{applicationContextModule});
        this.profilerConfig = (ProfilerConfig)this.injector.getInstance(ProfilerConfig.class);
        this.interceptorRegistryBinder = (InterceptorRegistryBinder)this.injector.getInstance(InterceptorRegistryBinder.class);
        this.instrumentEngine = (InstrumentEngine)this.injector.getInstance(InstrumentEngine.class);
        this.classFileTransformer = (ClassFileTransformer)this.injector.getInstance(ClassFileTransformer.class);
        this.dynamicTransformTrigger = (DynamicTransformTrigger)this.injector.getInstance(DynamicTransformTrigger.class);
        ClassFileTransformer classFileTransformer = this.wrap(this.classFileTransformer);
        JvmVersion version = JvmUtils.getVersion();
        if (version.onOrAfter(JvmVersion.JAVA_9)) {
            JavaModuleFactory javaModuleFactory = JavaModuleFactoryFinder.lookup(instrumentation);
            ClassFileTransformerModuleHandler classFileTransformModuleAdaptor = new ClassFileTransformerModuleHandler(instrumentation, classFileTransformer, javaModuleFactory);
            classFileTransformer = this.wrapJava9ClassFileTransformer(classFileTransformModuleAdaptor);
            this.lambdaFactorySetup(instrumentation, classFileTransformModuleAdaptor, javaModuleFactory);
            instrumentation.addTransformer(classFileTransformer, true);
        } else {
            instrumentation.addTransformer(classFileTransformer, true);
        }
        this.commandDispatcher = (CommandDispatcher)this.injector.getInstance(Key.get(CommandDispatcher.class));
        this.logger.info("commandDispatcher:{}", (Object)this.commandDispatcher);
        this.spanStatConnectTimer = (Timer)this.injector.getInstance(Key.get(Timer.class, SpanStatConnectTimer.class));
        this.logger.info("spanStatConnectTimer:{}", (Object)this.spanStatConnectTimer);
        this.spanStatChannelFactory = (ChannelFactory)this.injector.getInstance(Key.get(ChannelFactory.class, SpanStatChannelFactory.class));
        this.logger.info("spanStatChannelFactory:{}", (Object)this.spanStatChannelFactory);
        this.spanClientFactory = (PinpointClientFactory)this.injector.getInstance(Key.get(PinpointClientFactory.class, SpanClientFactory.class));
        this.logger.info("spanClientFactory:{}", (Object)this.spanClientFactory);
        this.statClientFactory = (PinpointClientFactory)this.injector.getInstance(Key.get(PinpointClientFactory.class, StatClientFactory.class));
        this.logger.info("statClientFactory:{}", (Object)this.statClientFactory);
        this.spanDataSender = this.newUdpSpanDataSender();
        this.logger.info("spanDataSender:{}", (Object)this.spanDataSender);
        this.statDataSender = this.newUdpStatDataSender();
        this.logger.info("statDataSender:{}", (Object)this.statDataSender);
        this.clientFactory = (PinpointClientFactory)this.injector.getInstance(Key.get(PinpointClientFactory.class, DefaultClientFactory.class));
        this.logger.info("clientFactory:{}", (Object)this.clientFactory);
        TypeLiteral<EnhancedDataSender<Object>> enhancedDataSenderLiteral = new TypeLiteral<EnhancedDataSender<Object>>(){};
        Key enhancedDataSenderKey = Key.get((TypeLiteral)enhancedDataSenderLiteral);
        this.tcpDataSender = (EnhancedDataSender)this.injector.getInstance(enhancedDataSenderKey);
        this.logger.info("tcpDataSender:{}", (Object)this.tcpDataSender);
        this.traceContext = (TraceContext)this.injector.getInstance(TraceContext.class);
        this.agentInformation = (AgentInformation)this.injector.getInstance(AgentInformation.class);
        this.logger.info("agentInformation:{}", (Object)this.agentInformation);
        this.serverMetaDataRegistryService = (ServerMetaDataRegistryService)this.injector.getInstance(ServerMetaDataRegistryService.class);
        this.deadlockMonitor = (DeadlockMonitor)this.injector.getInstance(DeadlockMonitor.class);
        this.agentInfoSender = (AgentInfoSender)this.injector.getInstance(AgentInfoSender.class);
        this.agentStatMonitor = (AgentStatMonitor)this.injector.getInstance(AgentStatMonitor.class);
    }

    private void lambdaFactorySetup(Instrumentation instrumentation, ClassFileTransformModuleAdaptor classFileTransformer, JavaModuleFactory javaModuleFactory) {
        JvmVersion version = JvmUtils.getVersion();
        if (version.onOrAfter(JvmVersion.JAVA_9)) {
            LambdaTransformBootloader lambdaTransformBootloader = new LambdaTransformBootloader();
            lambdaTransformBootloader.transformLambdaFactory(instrumentation, classFileTransformer, javaModuleFactory);
        }
    }

    private ClassFileTransformer wrapJava9ClassFileTransformer(ClassFileTransformModuleAdaptor classFileTransformer) {
        this.logger.info("initialize Java9ClassFileTransformer");
        String moduleWrap = "com.navercorp.pinpoint.bootstrap.java9.module.ClassFileTransformerModuleWrap";
        try {
            Class<?> cftClass = this.forName(moduleWrap, Object.class.getClassLoader());
            Constructor<?> constructor = cftClass.getDeclaredConstructor(ClassFileTransformModuleAdaptor.class);
            return (ClassFileTransformer)constructor.newInstance(classFileTransformer);
        }
        catch (Exception e) {
            throw new IllegalStateException(moduleWrap + " load fail Caused by:" + e.getMessage(), e);
        }
    }

    private Class<?> forName(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(className + " not found");
        }
    }

    private ClassFileTransformer wrap(ClassFileTransformer classFileTransformer) {
        boolean enableBytecodeDump = this.profilerConfig.readBoolean("bytecode.dump.enable", false);
        if (enableBytecodeDump) {
            this.logger.info("wrapBytecodeDumpTransformer");
            return BytecodeDumpTransformer.wrap(classFileTransformer, this.profilerConfig);
        }
        return classFileTransformer;
    }

    private DataSender newUdpStatDataSender() {
        Key statDataSenderKey = Key.get(DataSender.class, StatDataSender.class);
        return (DataSender)this.injector.getInstance(statDataSenderKey);
    }

    private DataSender newUdpSpanDataSender() {
        Key spanDataSenderKey = Key.get(DataSender.class, SpanDataSender.class);
        return (DataSender)this.injector.getInstance(spanDataSenderKey);
    }

    public ProfilerConfig getProfilerConfig() {
        return this.profilerConfig;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    public DataSender getSpanDataSender() {
        return this.spanDataSender;
    }

    public InstrumentEngine getInstrumentEngine() {
        return this.instrumentEngine;
    }

    public DynamicTransformTrigger getDynamicTransformTrigger() {
        return this.dynamicTransformTrigger;
    }

    public ClassFileTransformer getClassFileTransformer() {
        return this.classFileTransformer;
    }

    public AgentInformation getAgentInformation() {
        return this.agentInformation;
    }

    public ServerMetaDataRegistryService getServerMetaDataRegistryService() {
        return this.serverMetaDataRegistryService;
    }

    @Override
    public void start() {
        this.interceptorRegistryBinder.bind();
        this.deadlockMonitor.start();
        this.agentInfoSender.start();
        this.agentStatMonitor.start();
    }

    @Override
    public void close() {
        Set stop;
        this.agentInfoSender.stop();
        this.agentStatMonitor.stop();
        this.deadlockMonitor.stop();
        this.spanDataSender.stop();
        this.statDataSender.stop();
        if (this.spanClientFactory != null) {
            this.spanClientFactory.release();
        }
        if (this.statClientFactory != null) {
            this.statClientFactory.release();
        }
        if (this.spanStatChannelFactory != null) {
            this.spanStatChannelFactory.releaseExternalResources();
        }
        if (this.spanStatConnectTimer != null && !(stop = this.spanStatConnectTimer.stop()).isEmpty()) {
            this.logger.info("stop Timeout:{}", (Object)stop.size());
        }
        this.closeTcpDataSender();
        this.commandDispatcher.close();
        if (this.profilerConfig.getStaticResourceCleanup()) {
            this.interceptorRegistryBinder.unbind();
        }
    }

    private void closeTcpDataSender() {
        PinpointClientFactory clientFactory;
        EnhancedDataSender tcpDataSender = this.tcpDataSender;
        if (tcpDataSender != null) {
            tcpDataSender.stop();
        }
        if ((clientFactory = this.clientFactory) != null) {
            clientFactory.release();
        }
    }
}

