/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.util;

import com.navercorp.pinpoint.io.request.Message;
import com.navercorp.pinpoint.thrift.io.DeserializerFactory;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseDeserializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import com.navercorp.pinpoint.thrift.io.SerializerFactory;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationUtils.class);

    private SerializationUtils() {
    }

    public static byte[] serialize(TBase object, SerializerFactory<HeaderTBaseSerializer> factory) throws TException {
        SerializationUtils.assertNotNull(factory, "SerializerFactory may note be null.");
        return SerializationUtils.serialize(object, factory.createSerializer());
    }

    public static byte[] serialize(TBase object, HeaderTBaseSerializer serializer) throws TException {
        SerializationUtils.assertNotNull(object, "TBase may note be null.");
        SerializationUtils.assertNotNull(serializer, "Serializer may note be null.");
        return serializer.serialize(object);
    }

    public static byte[] serialize(TBase object, SerializerFactory<HeaderTBaseSerializer> factory, byte[] defaultValue) {
        try {
            return SerializationUtils.serialize(object, factory);
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Serialize " + object + " failed. Error:" + e.getMessage(), (Throwable)e);
            }
            return defaultValue;
        }
    }

    public static byte[] serialize(TBase object, HeaderTBaseSerializer serializer, byte[] defaultValue) {
        try {
            return SerializationUtils.serialize(object, serializer);
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Serialize " + object + " failed. Error:" + e.getMessage(), (Throwable)e);
            }
            return defaultValue;
        }
    }

    public static Message<TBase<?, ?>> deserialize(byte[] objectData, DeserializerFactory<HeaderTBaseDeserializer> factory) throws TException {
        SerializationUtils.assertNotNull(factory, "DeserializerFactory may note be null.");
        return SerializationUtils.deserialize(objectData, factory.createDeserializer());
    }

    public static Message<TBase<?, ?>> deserialize(byte[] objectData, HeaderTBaseDeserializer deserializer) throws TException {
        SerializationUtils.assertNotNull(objectData, "TBase may note be null.");
        SerializationUtils.assertNotNull(deserializer, "Deserializer may note be null.");
        return deserializer.deserialize(objectData);
    }

    public static Message<TBase<?, ?>> deserialize(byte[] objectData, DeserializerFactory<HeaderTBaseDeserializer> factory, Message<TBase<?, ?>> defaultValue) {
        try {
            return SerializationUtils.deserialize(objectData, factory);
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Deserialize failed. Error:" + e.getMessage(), (Throwable)e);
            }
            return defaultValue;
        }
    }

    public static Message<TBase<?, ?>> deserialize(byte[] objectData, HeaderTBaseDeserializer deserializer, Message<TBase<?, ?>> defaultValue) {
        try {
            return SerializationUtils.deserialize(objectData, deserializer);
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Deserialize failed. Error:" + e.getMessage(), (Throwable)e);
            }
            return defaultValue;
        }
    }

    private static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
    }
}

