/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils;

import com.secnium.iast.thirdparty.org.apache.commons.beanutils.DynaBean;
import com.secnium.iast.thirdparty.org.apache.commons.beanutils.DynaClass;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationMap;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.SubsetConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.beanutils.ConfigurationDynaClass;
import com.secnium.iast.thirdparty.org.apache.commons.logging.Log;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;

public class ConfigurationDynaBean
extends ConfigurationMap
implements DynaBean {
    private static final String PROPERTY_DELIMITER = ".";
    private static final Log LOG = LogFactory.getLog(ConfigurationDynaBean.class);

    public ConfigurationDynaBean(Configuration configuration) {
        super(configuration);
        if (LOG.isTraceEnabled()) {
            LOG.trace("ConfigurationDynaBean(" + configuration + ")");
        }
    }

    public void set(String string, Object object) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("set(" + string + "," + object + ")");
        }
        if (object == null) {
            throw new NullPointerException("Error trying to set property to null.");
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            for (Object e2 : collection) {
                this.getConfiguration().addProperty(string, e2);
            }
        } else if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.getConfiguration().addProperty(string, Array.get(object, i));
            }
        } else {
            this.getConfiguration().setProperty(string, object);
        }
    }

    public Object get(String string) {
        SubsetConfiguration subsetConfiguration;
        Object object;
        if (LOG.isTraceEnabled()) {
            LOG.trace("get(" + string + ")");
        }
        if ((object = this.getConfiguration().getProperty(string)) == null && !(subsetConfiguration = new SubsetConfiguration(this.getConfiguration(), string, PROPERTY_DELIMITER)).isEmpty()) {
            object = new ConfigurationDynaBean(subsetConfiguration);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(string + "=[" + object + "]");
        }
        if (object == null) {
            throw new IllegalArgumentException("Property '" + string + "' does not exist.");
        }
        return object;
    }

    public boolean contains(String string, String string2) {
        Configuration configuration = this.getConfiguration().subset(string);
        if (configuration == null) {
            throw new IllegalArgumentException("Mapped property '" + string + "' does not exist.");
        }
        return configuration.containsKey(string2);
    }

    public Object get(String string, int n) {
        if (!this.checkIndexedProperty(string)) {
            throw new IllegalArgumentException("Property '" + string + "' is not indexed.");
        }
        List<Object> list = this.getConfiguration().getList(string);
        return list.get(n);
    }

    public Object get(String string, String string2) {
        Configuration configuration = this.getConfiguration().subset(string);
        if (configuration == null) {
            throw new IllegalArgumentException("Mapped property '" + string + "' does not exist.");
        }
        return configuration.getProperty(string2);
    }

    public DynaClass getDynaClass() {
        return new ConfigurationDynaClass(this.getConfiguration());
    }

    public void remove(String string, String string2) {
        SubsetConfiguration subsetConfiguration = new SubsetConfiguration(this.getConfiguration(), string, PROPERTY_DELIMITER);
        subsetConfiguration.setProperty(string2, null);
    }

    public void set(String string, int n, Object object) {
        if (!this.checkIndexedProperty(string) && n > 0) {
            throw new IllegalArgumentException("Property '" + string + "' is not indexed.");
        }
        Object object2 = this.getConfiguration().getProperty(string);
        if (object2 instanceof List) {
            List list = (List)object2;
            list.set(n, object);
            this.getConfiguration().setProperty(string, list);
        } else if (object2.getClass().isArray()) {
            Array.set(object2, n, object);
        } else if (n == 0) {
            this.getConfiguration().setProperty(string, object);
        }
    }

    public void set(String string, String string2, Object object) {
        this.getConfiguration().setProperty(string + PROPERTY_DELIMITER + string2, object);
    }

    private boolean checkIndexedProperty(String string) {
        Object object = this.getConfiguration().getProperty(string);
        if (object == null) {
            throw new IllegalArgumentException("Property '" + string + "' does not exist.");
        }
        return object instanceof List || object.getClass().isArray();
    }
}

