/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.resolver;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationUtils;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileSystem;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrSubstitutor;
import com.secnium.iast.thirdparty.org.apache.commons.logging.Log;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.apache.xml.resolver.CatalogException;
import org.apache.xml.resolver.readers.CatalogReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CatalogResolver
implements EntityResolver {
    private static final int DEBUG_ALL = 9;
    private static final int DEBUG_NORMAL = 4;
    private static final int DEBUG_NONE = 0;
    protected CatalogManager manager = new CatalogManager();
    protected FileSystem fs = FileSystem.getDefaultFileSystem();
    private org.apache.xml.resolver.tools.CatalogResolver resolver;
    private Log log;

    public CatalogResolver() {
        this.manager.setIgnoreMissingProperties(true);
        this.manager.setUseStaticCatalog(false);
        this.manager.setFileSystem(this.fs);
        this.setLogger(null);
    }

    public void setCatalogFiles(String string) {
        this.manager.setCatalogFiles(string);
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fs = fileSystem;
        this.manager.setFileSystem(fileSystem);
    }

    public void setBaseDir(String string) {
        this.manager.setBaseDir(string);
    }

    public void setSubstitutor(StrSubstitutor strSubstitutor) {
        this.manager.setSubstitutor(strSubstitutor);
    }

    public void setDebug(boolean bl) {
        if (bl) {
            this.manager.setVerbosity(9);
        } else {
            this.manager.setVerbosity(0);
        }
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        String string3 = this.getResolver().getResolvedEntity(string, string2);
        if (string3 != null) {
            String string4 = "file://";
            String string5 = "file:///";
            if (string3.startsWith(string4) && !string3.startsWith(string5)) {
                string3 = string5 + string3.substring(string4.length());
            }
            try {
                InputStream inputStream = this.fs.getInputStream(null, string3);
                InputSource inputSource = new InputSource(string3);
                inputSource.setPublicId(string);
                inputSource.setByteStream(inputStream);
                return inputSource;
            }
            catch (Exception exception) {
                this.log.warn("Failed to create InputSource for " + string3 + " (" + exception.toString() + ")");
                return null;
            }
        }
        return null;
    }

    public Log getLogger() {
        return this.log;
    }

    public void setLogger(Log log) {
        this.log = log != null ? log : LogFactory.getLog(CatalogResolver.class);
    }

    private synchronized org.apache.xml.resolver.tools.CatalogResolver getResolver() {
        if (this.resolver == null) {
            this.resolver = new org.apache.xml.resolver.tools.CatalogResolver((org.apache.xml.resolver.CatalogManager)this.manager);
        }
        return this.resolver;
    }

    public static class Catalog
    extends org.apache.xml.resolver.Catalog {
        private FileSystem fs;
        private FileNameMap fileNameMap = URLConnection.getFileNameMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadSystemCatalogs() throws IOException {
            this.fs = ((CatalogManager)this.catalogManager).getFileSystem();
            String string = ((CatalogManager)this.catalogManager).getBaseDir();
            Vector vector = this.catalogManager.getCatalogFiles();
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    String string2 = (String)vector.elementAt(i);
                    URL uRL = null;
                    InputStream inputStream = null;
                    try {
                        uRL = ConfigurationUtils.locate(this.fs, string, string2);
                        if (uRL != null) {
                            inputStream = this.fs.getInputStream(uRL);
                        }
                    }
                    catch (ConfigurationException configurationException) {
                        String string3 = uRL == null ? string2 : uRL.toString();
                        this.catalogManager.debug.message(9, "Unable to get input stream for " + string3 + ". " + configurationException.getMessage());
                    }
                    if (inputStream != null) {
                        String string4 = this.fileNameMap.getContentTypeFor(string2);
                        try {
                            if (string4 != null) {
                                this.parseCatalog(string4, inputStream);
                                continue;
                            }
                        }
                        catch (Exception exception) {
                            this.catalogManager.debug.message(9, "Exception caught parsing input stream for " + string2 + ". " + exception.getMessage());
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    this.parseCatalog(string, string2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parseCatalog(String string, String string2) throws IOException {
            this.catalogCwd = this.base = ConfigurationUtils.locate(this.fs, string, string2);
            this.default_override = this.catalogManager.getPreferPublic();
            this.catalogManager.debug.message(4, "Parse catalog: " + string2);
            boolean bl = false;
            for (int i = 0; !bl && i < this.readerArr.size(); ++i) {
                InputStream inputStream;
                CatalogReader catalogReader = (CatalogReader)this.readerArr.get(i);
                try {
                    inputStream = this.fs.getInputStream(this.base);
                }
                catch (Exception exception) {
                    this.catalogManager.debug.message(4, "Unable to access " + this.base + exception.getMessage());
                    break;
                }
                try {
                    catalogReader.readCatalog((org.apache.xml.resolver.Catalog)this, inputStream);
                    bl = true;
                    continue;
                }
                catch (CatalogException catalogException) {
                    this.catalogManager.debug.message(4, "Parse failed for " + string2 + catalogException.getMessage());
                    if (catalogException.getExceptionType() != 7) continue;
                    break;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        inputStream = null;
                    }
                }
            }
            if (bl) {
                this.parsePendingCatalogs();
            }
        }

        protected String normalizeURI(String string) {
            StrSubstitutor strSubstitutor = ((CatalogManager)this.catalogManager).getStrSubstitutor();
            String string2 = strSubstitutor != null ? strSubstitutor.replace(string) : string;
            return super.normalizeURI(string2);
        }
    }

    public static class CatalogManager
    extends org.apache.xml.resolver.CatalogManager {
        private static org.apache.xml.resolver.Catalog staticCatalog;
        private FileSystem fs;
        private String baseDir = System.getProperty("user.dir");
        private StrSubstitutor substitutor;

        public void setFileSystem(FileSystem fileSystem) {
            this.fs = fileSystem;
        }

        public FileSystem getFileSystem() {
            return this.fs;
        }

        public void setBaseDir(String string) {
            if (string != null) {
                this.baseDir = string;
            }
        }

        public String getBaseDir() {
            return this.baseDir;
        }

        public void setSubstitutor(StrSubstitutor strSubstitutor) {
            this.substitutor = strSubstitutor;
        }

        public StrSubstitutor getStrSubstitutor() {
            return this.substitutor;
        }

        public org.apache.xml.resolver.Catalog getPrivateCatalog() {
            org.apache.xml.resolver.Catalog catalog = staticCatalog;
            if (catalog == null || !this.getUseStaticCatalog()) {
                try {
                    catalog = new Catalog();
                    catalog.setCatalogManager((org.apache.xml.resolver.CatalogManager)this);
                    catalog.setupReaders();
                    catalog.loadSystemCatalogs();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (this.getUseStaticCatalog()) {
                    staticCatalog = catalog;
                }
            }
            return catalog;
        }

        public org.apache.xml.resolver.Catalog getCatalog() {
            return this.getPrivateCatalog();
        }
    }
}

