#!/bin/sh

count=1
is_running=0

export NAMESPACE=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`

curl --request POST \
  --url http://192.168.29.116:9001/api/etcd/set_env_job_status \
  --header 'Content-Type: application/json' \
  --data "{\"namespace\": \"$NAMESPACE\",\"job_name\": \"rabbitmq_sync\",\"status\": \"pending\"}"


until [[ $count -eq 300 ]] || [[ $is_running -eq 1 ]]
do
  let count+=1
  echo "count is $count"
  curl -X GET -H "Authorization: Basic cWE6cWF0ZXN0" "http://rabbitmq:15672/api/definitions"
  
  if [ $? -eq 0 ]
    then
      echo "rabbitmq is running"
      is_running=1
    else
      echo "rabbitmq is not running"
      sleep 1
  fi
done

if [[ $is_running -eq 1 ]]
  then  
    echo "rabbitmq is running!!! start execution sync job"
	echo "get definitions from 172.16.1.231"
	response=$(curl -X GET -H "Authorization: Basic cmFiYml0X2FkbWluOmFiYzEyMzQ=" "http://172.16.1.231:15672/api/definitions")
	curl -X POST -H "Content-Type: application/json" -H "Authorization: Basic cWE6cWF0ZXN0" -d $response "http://rabbitmq:15672/api/definitions"
  else
    echo "rabbitmq is not running!!! Do not execution sync job"
fi

curl --request POST \
  --url http://192.168.29.116:9001/api/etcd/set_env_job_status \
  --header 'Content-Type: application/json' \
  --data "{\"namespace\": \"$NAMESPACE\",\"job_name\": \"rabbitmq_sync\",\"status\": \"done\"}"