#!/bin/bash

USER='qa'
PASSWORD='qatest'

count=1
db_is_running=0

export NAMESPACE=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`

curl --request POST \
  --url http://192.168.29.116:9001/api/etcd/set_env_job_status \
  --header 'Content-Type: application/json' \
  --data "{\"namespace\": \"$NAMESPACE\",\"job_name\": \"db_sync\",\"status\": \"pending\"}"

until [[ $count -eq 300 ]] || [[ $db_is_running -eq 1 ]]
do
  let count+=1
  echo "count is $count"
  mysqladmin -h db -u$USER -p$PASSWORD processlist
  if [ $? -eq 0 ]
    then
      echo "db is running"
      db_is_running=1
    else
      echo "db is not running"
      sleep 1
  fi
done

if [[ $db_is_running -eq 1 ]]
  then
    echo "db is running!!! start execution sync job"
	
    echo "start replace db domain"
    DB_FILE=dump.sql
    HOST=$DB_SERVICE_HOST
    PORT='3306'
    HTTPS='true'

    echo "HOST=$HOST
    PORT=$PORT
    USER=$USER
    PASSWORD=$PASSWORD
    HTTPS=$HTTPS
    NAMESPACE=$NAMESPACE"

    EXCLUDED_TABLES=(
    clotho.JOB_EXECUTION_LOG
    clotho.JOB_STATUS_TRACE_LOG
    notify.JOB_EXECUTION_LOG
    notify.JOB_STATUS_TRACE_LOG
    xyqb.JOB_EXECUTION_LOG
    xyqb.JOB_STATUS_TRACE_LOG
    xyqb.t_phonenum
    mall.jd_address
    mall.jd_brand
    mall.jd_product_sku_image
    mall.jd_property
    mall.jd_sku
    mall.jd_sku_detail_image
    mall.jd_sku_specs
    mall.spu_image
    mall.sale_product_detail
    mall.product_nature_value_bak
    mall.product_sku
    mall.product_sku_image
    mall.product_specification
    mall.product_spu
    )

    IGNORED_TABLES_STRING=''
    for TABLE in "${EXCLUDED_TABLES[@]}"
    do :
       IGNORED_TABLES_STRING+=" --ignore-table=${TABLE}"
    done

    echo "mysqldump --host=${HOST} --port=${PORT} --user=${USER} --password=${PASSWORD} --all-databases --no-create-info ${IGNORED_TABLES_STRING} > ${DB_FILE}"
    mysqldump --host=${HOST} --port=${PORT} --user=${USER} --password=${PASSWORD} --all-databases ${IGNORED_TABLES_STRING} >> ${DB_FILE}
    echo "sed file"
    if [[ $HTTPS = true ]];then
    	sed -i "s#\.xyqb\.com#-${NAMESPACE}\.q-gp\.com#g; s#\.quantgroup\.cn#-${NAMESPACE}\.q-gp\.com#g; s#-(\w*)\.q-gp\.com#-${NAMESPACE}\.q-gp\.com#g" ${DB_FILE}
    else
    	sed -i "s#\.xyqb\.com#-${NAMESPACE}\.q-gp\.com#g; s#\.quantgroup\.cn#-${NAMESPACE}\.q-gp\.com#g; s#-(\w*)\.q-gp\.com#-${NAMESPACE}\.q-gp\.com#g; s#\https#http#g" ${DB_FILE}
    fi

    echo "mysql dump file"
    mysql --host=${HOST} --port=${PORT}  --user=${USER} --password=${PASSWORD} < ${DB_FILE}
    
  else
    echo "db is not running!!! Do not execution replace job"
fi

#回调更新任务状态
count=1
db_is_running=0

until [[ $count -eq 60 ]] || [[ $db_is_running -eq 1 ]]
do
  let count+=1
  echo "count is $count"
  mysqladmin -h db -u$USER -p$PASSWORD processlist
  if [ $? -eq 0 ]
    then
		db_is_running=1
    else
      echo "db is not running"
      sleep 1
  fi
done

curl --request POST \
  --url http://192.168.29.116:9001/api/etcd/set_env_job_status \
  --header 'Content-Type: application/json' \
  --data "{\"namespace\": \"$NAMESPACE\",\"job_name\": \"db_sync\",\"status\": \"done\"}"
