/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request.util;

import com.navercorp.pinpoint.bootstrap.context.RemoteAddressResolver;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.common.util.Assert;

public class HeaderResolveRequestAdaptor<T>
implements RequestAdaptor<T> {
    private final RequestAdaptor<T> delegate;
    private final RemoteAddressResolver<T> remoteAddressResolver;

    public HeaderResolveRequestAdaptor(RequestAdaptor<T> delegate, RemoteAddressResolver<T> remoteAddressResolver) {
        this.delegate = (RequestAdaptor)Assert.requireNonNull(delegate, (String)"delegate must not be null");
        this.remoteAddressResolver = (RemoteAddressResolver)Assert.requireNonNull(remoteAddressResolver, (String)"remoteAddressResolver must not be null");
    }

    @Override
    public String getHeader(T request, String name) {
        return this.delegate.getHeader(request, name);
    }

    @Override
    public String getRpcName(T request) {
        return this.delegate.getRpcName(request);
    }

    @Override
    public String getEndPoint(T request) {
        return this.delegate.getEndPoint(request);
    }

    @Override
    public String getRemoteAddress(T request) {
        String remoteAddress = this.remoteAddressResolver.resolve(this.delegate, request);
        if (remoteAddress != null) {
            return remoteAddress;
        }
        return this.delegate.getRemoteAddress(request);
    }

    @Override
    public String getAcceptorHost(T request) {
        return this.delegate.getAcceptorHost(request);
    }
}

