/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.context.Header;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientHeaderAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceWriter;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StringUtils;

public class DefaultRequestTraceWriter<T>
implements RequestTraceWriter<T> {
    private static final String NOT_SET = null;
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final ClientHeaderAdaptor<T> clientHeaderAdaptor;
    private final String applicationName;
    private final short serverTypeCode;
    private final String applicationNamespace;

    public DefaultRequestTraceWriter(ClientHeaderAdaptor<T> clientHeaderAdaptor, TraceContext traceContext) {
        this(clientHeaderAdaptor, traceContext.getApplicationName(), traceContext.getServerTypeCode(), traceContext.getProfilerConfig().getApplicationNamespace());
    }

    public DefaultRequestTraceWriter(ClientHeaderAdaptor<T> clientHeaderAdaptor, String applicationName, short serverTypeCode, String applicationNamespace) {
        this.clientHeaderAdaptor = (ClientHeaderAdaptor)Assert.requireNonNull(clientHeaderAdaptor, (String)"clientHeaderAdaptor must not be null");
        this.applicationName = (String)Assert.requireNonNull((Object)applicationName, (String)"applicationName must not be null");
        this.serverTypeCode = serverTypeCode;
        this.applicationNamespace = StringUtils.isEmpty((String)applicationNamespace) ? NOT_SET : applicationNamespace;
    }

    @Override
    public void write(T header) {
        if (this.isDebug) {
            this.logger.debug("Set request header that is not to be sampled.");
        }
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_SAMPLED.toString(), "s0");
    }

    @Override
    public void write(T header, TraceId traceId, String host) {
        Assert.requireNonNull((Object)traceId, (String)"traceId must not be null");
        if (this.isDebug) {
            this.logger.debug("Set request header. traceId={}, applicationName={}, serverTypeCode={}, applicationNamespace={}", traceId, this.applicationName, this.serverTypeCode, this.applicationNamespace);
        }
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_TRACE_ID.toString(), traceId.getTransactionId());
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_SPAN_ID.toString(), String.valueOf(traceId.getSpanId()));
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_PARENT_SPAN_ID.toString(), String.valueOf(traceId.getParentSpanId()));
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_FLAGS.toString(), String.valueOf(traceId.getFlags()));
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_PARENT_APPLICATION_NAME.toString(), this.applicationName);
        this.clientHeaderAdaptor.setHeader(header, Header.HTTP_PARENT_APPLICATION_TYPE.toString(), Short.toString(this.serverTypeCode));
        if (this.applicationNamespace != NOT_SET) {
            this.clientHeaderAdaptor.setHeader(header, Header.HTTP_PARENT_APPLICATION_NAMESPACE.toString(), this.applicationNamespace);
        }
        if (host != null) {
            this.clientHeaderAdaptor.setHeader(header, Header.HTTP_HOST.toString(), host);
        }
    }
}

