/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.logger.autolog.processor;

import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessException;
import com.tapm.starter.util.StarterUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public final class AutoDirScanProcessor
implements IProcessor {
    private static final Map<Integer, File> contentMap = new HashMap<Integer, File>();

    @Override
    public String process(ProcessContext context) throws ProcessException {
        File[] files;
        File baseWorkDir = (File)context.get("baseWorkDir");
        Integer index = (Integer)context.get("index");
        if (baseWorkDir.isDirectory() && (files = baseWorkDir.listFiles()) != null) {
            for (File listFile : files) {
                if (!listFile.isDirectory() || !StarterUtil.isNumeric(listFile.getName())) continue;
                int fileDirId = Integer.parseInt(listFile.getName());
                contentMap.put(fileDirId, listFile);
            }
        }
        if (contentMap.containsKey(index)) {
            context.put("processDir", contentMap.get(index));
            return "next";
        }
        return "createDir";
    }
}

