/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.okhttp.v2.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.plugin.okhttp.OkHttpConstants;
import com.navercorp.pinpoint.plugin.okhttp.v2.UserRequestGetter;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Request;

public class HttpEngineConnectMethodFromUserRequestInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    public HttpEngineConnectMethodFromUserRequestInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        super(traceContext, descriptor);
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        Request request;
        recorder.recordApi(this.methodDescriptor);
        recorder.recordServiceType(OkHttpConstants.OK_HTTP_CLIENT_INTERNAL);
        recorder.recordException(throwable);
        if (target instanceof UserRequestGetter && (request = ((UserRequestGetter)target)._$PINPOINT$_getUserRequest()) != null && request.httpUrl() != null) {
            HttpUrl httpUrl = request.httpUrl();
            String hostAndPort = HostAndPort.toHostAndPortString((String)httpUrl.host(), (int)httpUrl.port());
            recorder.recordAttribute(AnnotationKey.HTTP_INTERNAL_DISPLAY, hostAndPort);
        }
    }
}

