/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.resolver;

import com.navercorp.pinpoint.bootstrap.resolver.condition.ClassResourceCondition;
import com.navercorp.pinpoint.bootstrap.resolver.condition.MainClassCondition;
import com.navercorp.pinpoint.bootstrap.resolver.condition.PropertyCondition;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.List;

public class ConditionProvider {
    public static final ConditionProvider DEFAULT_CONDITION_PROVIDER = new ConditionProvider();
    private final MainClassCondition mainClassCondition;
    private final PropertyCondition systemPropertyCondition;
    private final ClassResourceCondition classResourceCondition;

    private ConditionProvider() {
        this(new MainClassCondition(), new PropertyCondition(), new ClassResourceCondition());
    }

    ConditionProvider(MainClassCondition mainClassCondition, PropertyCondition systemPropertyCondition, ClassResourceCondition classResourceCondition) {
        this.mainClassCondition = mainClassCondition;
        this.systemPropertyCondition = systemPropertyCondition;
        this.classResourceCondition = classResourceCondition;
    }

    public String getMainClass() {
        return this.mainClassCondition.getValue();
    }

    public boolean checkMainClass(String candidate) {
        if (candidate == null) {
            return false;
        }
        String trimmedCandidate = candidate.trim();
        return this.mainClassCondition.check(trimmedCandidate);
    }

    public boolean checkMainClass(List<String> candidates) {
        if (CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        for (String candidate : candidates) {
            if (!this.checkMainClass(candidate)) continue;
            return true;
        }
        return false;
    }

    public String getSystemPropertyValue(String systemPropertyKey) {
        if (StringUtils.isEmpty((String)systemPropertyKey)) {
            return "";
        }
        return this.systemPropertyCondition.getValue().getProperty(systemPropertyKey);
    }

    public boolean checkSystemProperty(String systemPropertyKey) {
        return this.systemPropertyCondition.check(systemPropertyKey);
    }

    public boolean checkForClass(String requiredClass) {
        return this.classResourceCondition.check(requiredClass);
    }
}

