/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.DataSourceMonitor;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.plugin.druid.DruidConstants;

public class DruidDataSourceMonitor
implements DataSourceMonitor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private volatile boolean closed = false;
    private final DruidDataSource dataSource;

    public DruidDataSourceMonitor(Object dataSource) {
        if (dataSource instanceof DruidDataSource) {
            this.dataSource = (DruidDataSource)dataSource;
        } else {
            this.dataSource = null;
            this.logger.error("DataSource must be instance of DruidDataSource!");
        }
    }

    public ServiceType getServiceType() {
        return DruidConstants.SERVICE_TYPE;
    }

    public String getUrl() {
        if (this.dataSource != null) {
            return this.dataSource.getUrl();
        }
        return null;
    }

    public int getActiveConnectionSize() {
        if (this.dataSource != null) {
            return this.dataSource.getActiveCount();
        }
        return -1;
    }

    public int getMaxConnectionSize() {
        if (this.dataSource != null) {
            return this.dataSource.getMaxActive();
        }
        return -1;
    }

    public boolean isDisabled() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
    }
}

