/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.hikaricp;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.hikaricp.HikariCpConfig;
import com.navercorp.pinpoint.plugin.hikaricp.HikariCpConstants;
import java.security.ProtectionDomain;

public class HikariCpPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private HikariCpConfig config;
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        this.config = new HikariCpConfig(context.getConfig());
        if (!this.config.isPluginEnable()) {
            this.logger.info("Disable hikaricp option. 'profiler.jdbc.hikaricp=false'");
            return;
        }
        this.addBasicDataSourceTransformer();
        if (this.config.isProfileClose()) {
            this.addPoolGuardConnectionWrapperTransformer();
        }
        this.addHikariPoolTransformer();
    }

    private void addBasicDataSourceTransformer() {
        this.transformTemplate.transform("com.zaxxer.hikari.HikariDataSource", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod constructor = target.getConstructor(new String[0]);
                if (constructor != null) {
                    constructor.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor", VarArgs.va((Object[])new Object[]{HikariCpConstants.SERVICE_TYPE}), "HIKARICP_SCOPE");
                }
                if ((constructor = target.getConstructor(new String[]{"com.zaxxer.hikari.HikariConfig"})) != null) {
                    constructor.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor", VarArgs.va((Object[])new Object[]{HikariCpConstants.SERVICE_TYPE}), "HIKARICP_SCOPE");
                }
                InstrumentMethod getConnectionMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"getConnection", (String[])new String[0]);
                getConnectionMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.hikaricp.interceptor.DataSourceGetConnectionInterceptor", "HIKARICP_SCOPE");
                getConnectionMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"getConnection", (String[])new String[]{"java.lang.String", "java.lang.String"});
                getConnectionMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.hikaricp.interceptor.DataSourceGetConnectionInterceptor", "DEPRECATED_HIKARICP_SCOPE");
                return target.toBytecode();
            }
        });
    }

    private void addPoolGuardConnectionWrapperTransformer() {
        this.transformTemplate.transform("com.zaxxer.hikari.pool.ProxyConnection", (TransformCallback)new ConnectionTransformCallback());
        this.transformTemplate.transform("com.zaxxer.hikari.proxy.ConnectionProxy", (TransformCallback)new ConnectionTransformCallback());
    }

    private void addHikariPoolTransformer() {
        this.transformTemplate.transform("com.zaxxer.hikari.pool.HikariPool", (TransformCallback)new HikariPoolTransformCallback());
        this.transformTemplate.transform("com.zaxxer.hikari.pool.BaseHikariPool", (TransformCallback)new HikariPoolTransformCallback());
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    private static class HikariPoolTransformCallback
    implements TransformCallback {
        private HikariPoolTransformCallback() {
        }

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
            if (this.isAvailableDataSourceMonitor(target)) {
                InstrumentMethod constructor = target.getConstructor(new String[]{"com.zaxxer.hikari.HikariConfig", "java.lang.String", "java.lang.String"});
                if (constructor != null) {
                    this.addDataSourceMonitorInterceptor(target, constructor);
                    return target.toBytecode();
                }
                constructor = target.getConstructor(new String[]{"com.zaxxer.hikari.HikariConfig"});
                if (constructor != null) {
                    this.addDataSourceMonitorInterceptor(target, constructor);
                    return target.toBytecode();
                }
            }
            return target.toBytecode();
        }

        private boolean isAvailableDataSourceMonitor(InstrumentClass target) {
            InstrumentMethod getActiveConnectionsMethod = target.getDeclaredMethod("getActiveConnections", new String[0]);
            if (getActiveConnectionsMethod == null || !Integer.TYPE.getName().equals(getActiveConnectionsMethod.getReturnType())) {
                return false;
            }
            InstrumentMethod getTotalConnectionsMethod = target.getDeclaredMethod("getTotalConnections", new String[0]);
            return getTotalConnectionsMethod != null && Integer.TYPE.getName().equals(getTotalConnectionsMethod.getReturnType());
        }

        private void addDataSourceMonitorInterceptor(InstrumentClass target, InstrumentMethod constructor) throws InstrumentException {
            target.addField("com.navercorp.pinpoint.plugin.hikaricp.DataSourceMonitorAccessor");
            constructor.addScopedInterceptor("com.navercorp.pinpoint.plugin.hikaricp.interceptor.DataSourceConstructorInterceptor", "HIKARICP_SCOPE", ExecutionPolicy.INTERNAL);
            InstrumentMethod shutdownMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"shutdown", (String[])new String[0]);
            shutdownMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.hikaricp.interceptor.DataSourceCloseInterceptor", "HIKARICP_SCOPE", ExecutionPolicy.ALWAYS);
        }
    }

    private static class ConnectionTransformCallback
    implements TransformCallback {
        private ConnectionTransformCallback() {
        }

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
            InstrumentMethod closeMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]);
            closeMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.hikaricp.interceptor.DataSourceCloseConnectionInterceptor", "HIKARICP_SCOPE");
            return target.toBytecode();
        }
    }
}

