/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.mysql;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.PreparedStatementBindingMethodFilter;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.jdbc.mysql.MySqlConfig;
import com.navercorp.pinpoint.plugin.jdbc.mysql.MySqlConstants;
import com.navercorp.pinpoint.plugin.jdbc.mysql.MySqlJdbcUrlParser;
import java.security.ProtectionDomain;
import java.util.List;

public class MySqlPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private static final String MYSQL_SCOPE = "MYSQL_JDBC";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;
    private final JdbcUrlParserV2 jdbcUrlParser = new MySqlJdbcUrlParser();

    public void setup(ProfilerPluginSetupContext context) {
        MySqlConfig config = new MySqlConfig(context.getConfig());
        if (!config.isPluginEnable()) {
            this.logger.info("Mysql plugin is not executed because plugin enable value is false.");
            return;
        }
        context.addJdbcUrlParser(this.jdbcUrlParser);
        this.addConnectionTransformer(config);
        this.addDriverTransformer();
        this.addStatementTransformer();
        this.addPreparedStatementTransformer(config);
        this.addCallableStatementTransformer(config);
        this.addJDBC4PreparedStatementTransformer(config);
        this.addJDBC4CallableStatementTransformer(config);
    }

    private void addConnectionTransformer(final MySqlConfig config) {
        TransformCallback transformer = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod constructor_6_X;
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentMethod constructor = target.getConstructor(new String[]{"java.lang.String", "int", "java.util.Properties", "java.lang.String", "java.lang.String"});
                if (constructor != null) {
                    constructor.addInterceptor("com.navercorp.pinpoint.plugin.jdbc.mysql.interceptor.MySQLConnectionCreateInterceptor");
                }
                if ((constructor_6_X = target.getConstructor(new String[]{"com.mysql.cj.core.ConnectionString", "java.lang.String", "int", "java.util.Properties"})) == null) {
                    constructor_6_X = target.getConstructor(new String[]{"com.mysql.cj.core.conf.url.HostInfo"});
                }
                if (constructor_6_X == null) {
                    constructor_6_X = target.getConstructor(new String[]{"com.mysql.cj.conf.HostInfo"});
                }
                if (constructor_6_X != null) {
                    target.addGetter("com.navercorp.pinpoint.plugin.jdbc.mysql.interceptor.getter.OrigHostToConnectToGetter", "origHostToConnectTo");
                    target.addGetter("com.navercorp.pinpoint.plugin.jdbc.mysql.interceptor.getter.OrigPortToConnectToGetter", "origPortToConnectTo");
                    target.addGetter("com.navercorp.pinpoint.plugin.jdbc.mysql.interceptor.getter.DatabaseGetter", "database");
                    constructor_6_X.addInterceptor("com.navercorp.pinpoint.plugin.jdbc.mysql.interceptor.MySQL_6_X_ConnectionCreateInterceptor");
                }
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.ConnectionCloseInterceptor", MySqlPlugin.MYSQL_SCOPE);
                String statementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                String preparedStatementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int[]"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "java.lang.String[]"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                if (config.isProfileSetAutoCommit()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"setAutoCommit", (String[])new String[]{"boolean"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionSetAutoCommitInterceptor", MySqlPlugin.MYSQL_SCOPE);
                }
                if (config.isProfileCommit()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"commit", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionCommitInterceptor", MySqlPlugin.MYSQL_SCOPE);
                }
                if (config.isProfileRollback()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"rollback", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionRollbackInterceptor", MySqlPlugin.MYSQL_SCOPE);
                }
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("com.mysql.jdbc.Connection", transformer);
        this.transformTemplate.transform("com.mysql.jdbc.ConnectionImpl", transformer);
        this.transformTemplate.transform("com.mysql.cj.jdbc.ConnectionImpl", transformer);
    }

    private void addDriverTransformer() {
        TransformCallback transformCallback = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"connect", (String[])new String[]{"java.lang.String", "java.util.Properties"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.DriverConnectInterceptorV2", VarArgs.va((Object[])new Object[]{MySqlConstants.MYSQL, false}), MySqlPlugin.MYSQL_SCOPE, ExecutionPolicy.ALWAYS);
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("com.mysql.jdbc.NonRegisteringDriver", transformCallback);
        this.transformTemplate.transform("com.mysql.cj.jdbc.NonRegisteringDriver", transformCallback);
    }

    private void addPreparedStatementTransformer(final MySqlConfig config) {
        TransformCallback transformCallback = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod executeUpdateMethod;
                InstrumentMethod executeQueryMethod;
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor");
                int maxBindValueSize = config.getMaxSqlBindValueSize();
                String preparedStatementInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor";
                InstrumentMethod executeMethod = target.getDeclaredMethod("execute", new String[0]);
                if (executeMethod != null) {
                    executeMethod.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), MySqlPlugin.MYSQL_SCOPE);
                }
                if ((executeQueryMethod = target.getDeclaredMethod("executeQuery", new String[0])) != null) {
                    executeQueryMethod.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), MySqlPlugin.MYSQL_SCOPE);
                }
                if ((executeUpdateMethod = target.getDeclaredMethod("executeUpdate", new String[0])) != null) {
                    executeUpdateMethod.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), MySqlPlugin.MYSQL_SCOPE);
                }
                if (config.isTraceSqlBindValue()) {
                    PreparedStatementBindingMethodFilter excludes = PreparedStatementBindingMethodFilter.excludes((String[])new String[]{"setRowId", "setNClob", "setSQLXML"});
                    List declaredMethods = target.getDeclaredMethods((MethodFilter)excludes);
                    for (InstrumentMethod method : declaredMethods) {
                        method.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementBindVariableInterceptor", MySqlPlugin.MYSQL_SCOPE, ExecutionPolicy.BOUNDARY);
                    }
                }
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("com.mysql.jdbc.PreparedStatement", transformCallback);
        this.transformTemplate.transform("com.mysql.cj.jdbc.PreparedStatement", transformCallback);
        this.transformTemplate.transform("com.mysql.cj.jdbc.ClientPreparedStatement", transformCallback);
        this.transformTemplate.transform("com.mysql.cj.jdbc.ServerPreparedStatement", transformCallback);
    }

    private void addCallableStatementTransformer(final MySqlConfig config) {
        TransformCallback transformCallback = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor");
                int maxBindValueSize = config.getMaxSqlBindValueSize();
                String callableStatementExecuteQuery = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementExecuteQueryInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), MySqlPlugin.MYSQL_SCOPE);
                String registerOutParameterInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int", "java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor", MySqlPlugin.MYSQL_SCOPE);
                if (config.isTraceSqlBindValue()) {
                    PreparedStatementBindingMethodFilter excludes = PreparedStatementBindingMethodFilter.excludes((String[])new String[]{"setRowId", "setNClob", "setSQLXML"});
                    List declaredMethods = target.getDeclaredMethods((MethodFilter)excludes);
                    for (InstrumentMethod method : declaredMethods) {
                        method.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementBindVariableInterceptor", MySqlPlugin.MYSQL_SCOPE, ExecutionPolicy.BOUNDARY);
                    }
                }
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("com.mysql.jdbc.CallableStatement", transformCallback);
        this.transformTemplate.transform("com.mysql.cj.jdbc.CallableStatement", transformCallback);
    }

    private void addJDBC4PreparedStatementTransformer(final MySqlConfig config) {
        this.transformTemplate.transform("com.mysql.jdbc.JDBC4PreparedStatement", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (config.isTraceSqlBindValue()) {
                    PreparedStatementBindingMethodFilter includes = PreparedStatementBindingMethodFilter.includes((String[])new String[]{"setRowId", "setNClob", "setSQLXML"});
                    List declaredMethods = target.getDeclaredMethods((MethodFilter)includes);
                    for (InstrumentMethod method : declaredMethods) {
                        method.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementBindVariableInterceptor", MySqlPlugin.MYSQL_SCOPE, ExecutionPolicy.BOUNDARY);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    private void addJDBC4CallableStatementTransformer(final MySqlConfig config) {
        this.transformTemplate.transform("com.mysql.jdbc.JDBC4CallableStatement", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (config.isTraceSqlBindValue()) {
                    PreparedStatementBindingMethodFilter includes = PreparedStatementBindingMethodFilter.includes((String[])new String[]{"setRowId", "setNClob", "setSQLXML"});
                    List declaredMethods = target.getDeclaredMethods((MethodFilter)includes);
                    for (InstrumentMethod method : declaredMethods) {
                        method.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementBindVariableInterceptor", MySqlPlugin.MYSQL_SCOPE, ExecutionPolicy.BOUNDARY);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    private void addStatementTransformer() {
        TransformCallback transformer = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                String executeQueryInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor", MySqlPlugin.MYSQL_SCOPE);
                String executeUpdateInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", MySqlPlugin.MYSQL_SCOPE);
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("com.mysql.jdbc.Statement", transformer);
        this.transformTemplate.transform("com.mysql.jdbc.StatementImpl", transformer);
        this.transformTemplate.transform("com.mysql.cj.jdbc.StatementImpl", transformer);
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

