/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.common.service.ServiceTypeRegistryService;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.profiler.plugin.PluginContextLoadResult;
import com.navercorp.pinpoint.profiler.util.ApplicationServerTypeResolver;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationServerTypeProvider
implements Provider<ServiceType> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;
    private final ServiceTypeRegistryService serviceTypeRegistryService;
    private final Provider<PluginContextLoadResult> pluginContextLoadResultProvider;

    @Inject
    public ApplicationServerTypeProvider(ProfilerConfig profilerConfig, ServiceTypeRegistryService serviceTypeRegistryService, Provider<PluginContextLoadResult> pluginContextLoadResultProvider) {
        if (profilerConfig == null) {
            throw new NullPointerException("profilerConfig must not be null");
        }
        if (serviceTypeRegistryService == null) {
            throw new NullPointerException("serviceTypeRegistryService must not be null");
        }
        this.profilerConfig = profilerConfig;
        this.serviceTypeRegistryService = serviceTypeRegistryService;
        this.pluginContextLoadResultProvider = pluginContextLoadResultProvider;
    }

    public ServiceType get() {
        ServiceType applicationServiceType = this.getApplicationServiceType();
        this.logger.info("default ApplicationServerType={}", (Object)applicationServiceType);
        PluginContextLoadResult pluginContextLoadResult = (PluginContextLoadResult)this.pluginContextLoadResultProvider.get();
        List<ApplicationTypeDetector> applicationTypeDetectorList = pluginContextLoadResult.getApplicationTypeDetectorList();
        ApplicationServerTypeResolver applicationServerTypeResolver = new ApplicationServerTypeResolver(applicationTypeDetectorList, applicationServiceType, this.profilerConfig.getApplicationTypeDetectOrder());
        ServiceType resolve = applicationServerTypeResolver.resolve();
        this.logger.info("resolved ApplicationServerType={}", (Object)resolve);
        return resolve;
    }

    private ServiceType getApplicationServiceType() {
        String applicationServerTypeString = this.profilerConfig.getApplicationServerType();
        return this.serviceTypeRegistryService.findServiceTypeByName(applicationServerTypeString);
    }
}

