/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import java.util.List;

public class VertxConfig {
    private final boolean enable;
    private final boolean enableHttpServer;
    private final boolean enableHttpClient;
    private final List<String> bootstrapMains;
    private final List<String> handlerBasePackageNames;

    public VertxConfig(ProfilerConfig config) {
        if (config == null) {
            throw new NullPointerException("config must not be null");
        }
        this.enable = config.readBoolean("profiler.vertx.enable", false);
        this.enableHttpServer = config.readBoolean("profiler.vertx.http.server.enable", true);
        this.enableHttpClient = config.readBoolean("profiler.vertx.http.client.enable", true);
        this.bootstrapMains = config.readList("profiler.vertx.bootstrap.main");
        this.handlerBasePackageNames = config.readList("profiler.vertx.handler.base-packages");
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isEnableHttpServer() {
        return this.enableHttpServer;
    }

    public boolean isEnableHttpClient() {
        return this.enableHttpClient;
    }

    public List<String> getBootstrapMains() {
        return this.bootstrapMains;
    }

    public List<String> getHandlerBasePackageNames() {
        return this.handlerBasePackageNames;
    }
}

