/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.util;

import com.navercorp.pinpoint.bootstrap.util.SimpleSampler;
import com.navercorp.pinpoint.common.util.MathUtils;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleSamplerFactory {
    public static final SimpleSampler FALSE_SAMPLER = new SimpleFalseSampler();
    public static final SimpleSampler TRUE_SAMPLER = new SimpleTrueSampler();

    public static SimpleSampler createSampler(boolean sampling, int samplingRate) {
        if (!sampling || samplingRate <= 0) {
            return FALSE_SAMPLER;
        }
        if (samplingRate == 1) {
            return TRUE_SAMPLER;
        }
        return new SamplingRateSampler(samplingRate);
    }

    public static class SamplingRateSampler
    implements SimpleSampler {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final int samplingRate;

        public SamplingRateSampler(int samplingRate) {
            if (samplingRate <= 0) {
                throw new IllegalArgumentException("Invalid samplingRate " + samplingRate);
            }
            this.samplingRate = samplingRate;
        }

        @Override
        public boolean isSampling() {
            int samplingCount = MathUtils.fastAbs((int)this.counter.getAndIncrement());
            int isSampling = samplingCount % this.samplingRate;
            return isSampling == 0;
        }
    }

    public static class SimpleFalseSampler
    implements SimpleSampler {
        @Override
        public boolean isSampling() {
            return false;
        }
    }

    public static class SimpleTrueSampler
    implements SimpleSampler {
        @Override
        public boolean isSampling() {
            return true;
        }
    }
}

