/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.CombinedConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.SubnodeConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationErrorListener;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationListener;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ExpressionEngine;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.NodeCombiner;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrSubstitutor;
import com.secnium.iast.thirdparty.org.apache.commons.logging.Log;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicCombinedConfiguration
extends CombinedConfiguration {
    private static ThreadLocal<Boolean> recursive = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final ConcurrentMap<String, CombinedConfiguration> configs = new ConcurrentHashMap<String, CombinedConfiguration>();
    private List<ConfigData> configurations = new ArrayList<ConfigData>();
    private Map<String, AbstractConfiguration> namedConfigurations = new HashMap<String, AbstractConfiguration>();
    private String keyPattern;
    private NodeCombiner nodeCombiner;
    private String loggerName = DynamicCombinedConfiguration.class.getName();
    private StrSubstitutor localSubst = new StrSubstitutor(new ConfigurationInterpolator());

    public DynamicCombinedConfiguration(NodeCombiner nodeCombiner) {
        this.setNodeCombiner(nodeCombiner);
        this.setIgnoreReloadExceptions(false);
        this.setLogger(LogFactory.getLog(DynamicCombinedConfiguration.class));
    }

    public DynamicCombinedConfiguration() {
        this.setIgnoreReloadExceptions(false);
        this.setLogger(LogFactory.getLog(DynamicCombinedConfiguration.class));
    }

    public void setKeyPattern(String string) {
        this.keyPattern = string;
    }

    public String getKeyPattern() {
        return this.keyPattern;
    }

    public void setLoggerName(String string) {
        this.loggerName = string;
    }

    @Override
    public NodeCombiner getNodeCombiner() {
        return this.nodeCombiner;
    }

    @Override
    public void setNodeCombiner(NodeCombiner nodeCombiner) {
        if (nodeCombiner == null) {
            throw new IllegalArgumentException("Node combiner must not be null!");
        }
        this.nodeCombiner = nodeCombiner;
        this.invalidateAll();
    }

    @Override
    public void addConfiguration(AbstractConfiguration abstractConfiguration, String string, String string2) {
        ConfigData configData = new ConfigData(abstractConfiguration, string, string2);
        this.configurations.add(configData);
        if (string != null) {
            this.namedConfigurations.put(string, abstractConfiguration);
        }
    }

    @Override
    public int getNumberOfConfigurations() {
        return this.configurations.size();
    }

    @Override
    public Configuration getConfiguration(int n) {
        ConfigData configData = this.configurations.get(n);
        return configData.getConfiguration();
    }

    @Override
    public Configuration getConfiguration(String string) {
        return this.namedConfigurations.get(string);
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.namedConfigurations.keySet();
    }

    @Override
    public Configuration removeConfiguration(String string) {
        Configuration configuration = this.getConfiguration(string);
        if (configuration != null) {
            this.removeConfiguration(configuration);
        }
        return configuration;
    }

    @Override
    public boolean removeConfiguration(Configuration configuration) {
        for (int i = 0; i < this.getNumberOfConfigurations(); ++i) {
            if (this.configurations.get(i).getConfiguration() != configuration) continue;
            this.removeConfigurationAt(i);
        }
        return super.removeConfiguration(configuration);
    }

    @Override
    public Configuration removeConfigurationAt(int n) {
        ConfigData configData = this.configurations.remove(n);
        if (configData.getName() != null) {
            this.namedConfigurations.remove(configData.getName());
        }
        return super.removeConfigurationAt(n);
    }

    @Override
    public ConfigurationNode getRootNode() {
        return this.getCurrentConfig().getRootNode();
    }

    @Override
    public void setRootNode(ConfigurationNode configurationNode) {
        if (this.configs != null) {
            this.getCurrentConfig().setRootNode(configurationNode);
        } else {
            super.setRootNode(configurationNode);
        }
    }

    @Override
    public void addProperty(String string, Object object) {
        this.getCurrentConfig().addProperty(string, object);
    }

    @Override
    public void clear() {
        if (this.configs != null) {
            this.getCurrentConfig().clear();
        }
    }

    @Override
    public void clearProperty(String string) {
        this.getCurrentConfig().clearProperty(string);
    }

    @Override
    public boolean containsKey(String string) {
        return this.getCurrentConfig().containsKey(string);
    }

    @Override
    public BigDecimal getBigDecimal(String string, BigDecimal bigDecimal) {
        return this.getCurrentConfig().getBigDecimal(string, bigDecimal);
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        return this.getCurrentConfig().getBigDecimal(string);
    }

    @Override
    public BigInteger getBigInteger(String string, BigInteger bigInteger) {
        return this.getCurrentConfig().getBigInteger(string, bigInteger);
    }

    @Override
    public BigInteger getBigInteger(String string) {
        return this.getCurrentConfig().getBigInteger(string);
    }

    @Override
    public boolean getBoolean(String string, boolean bl) {
        return this.getCurrentConfig().getBoolean(string, bl);
    }

    @Override
    public Boolean getBoolean(String string, Boolean bl) {
        return this.getCurrentConfig().getBoolean(string, bl);
    }

    @Override
    public boolean getBoolean(String string) {
        return this.getCurrentConfig().getBoolean(string);
    }

    @Override
    public byte getByte(String string, byte by) {
        return this.getCurrentConfig().getByte(string, by);
    }

    @Override
    public Byte getByte(String string, Byte by) {
        return this.getCurrentConfig().getByte(string, by);
    }

    @Override
    public byte getByte(String string) {
        return this.getCurrentConfig().getByte(string);
    }

    @Override
    public double getDouble(String string, double d2) {
        return this.getCurrentConfig().getDouble(string, d2);
    }

    @Override
    public Double getDouble(String string, Double d2) {
        return this.getCurrentConfig().getDouble(string, d2);
    }

    @Override
    public double getDouble(String string) {
        return this.getCurrentConfig().getDouble(string);
    }

    @Override
    public float getFloat(String string, float f2) {
        return this.getCurrentConfig().getFloat(string, f2);
    }

    @Override
    public Float getFloat(String string, Float f2) {
        return this.getCurrentConfig().getFloat(string, f2);
    }

    @Override
    public float getFloat(String string) {
        return this.getCurrentConfig().getFloat(string);
    }

    @Override
    public int getInt(String string, int n) {
        return this.getCurrentConfig().getInt(string, n);
    }

    @Override
    public int getInt(String string) {
        return this.getCurrentConfig().getInt(string);
    }

    @Override
    public Integer getInteger(String string, Integer n) {
        return this.getCurrentConfig().getInteger(string, n);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.getCurrentConfig().getKeys();
    }

    @Override
    public Iterator<String> getKeys(String string) {
        return this.getCurrentConfig().getKeys(string);
    }

    @Override
    public List<Object> getList(String string, List<?> list) {
        return this.getCurrentConfig().getList(string, list);
    }

    @Override
    public List<Object> getList(String string) {
        return this.getCurrentConfig().getList(string);
    }

    @Override
    public long getLong(String string, long l) {
        return this.getCurrentConfig().getLong(string, l);
    }

    @Override
    public Long getLong(String string, Long l) {
        return this.getCurrentConfig().getLong(string, l);
    }

    @Override
    public long getLong(String string) {
        return this.getCurrentConfig().getLong(string);
    }

    @Override
    public Properties getProperties(String string) {
        return this.getCurrentConfig().getProperties(string);
    }

    @Override
    public Object getProperty(String string) {
        return this.getCurrentConfig().getProperty(string);
    }

    @Override
    public short getShort(String string, short s) {
        return this.getCurrentConfig().getShort(string, s);
    }

    @Override
    public Short getShort(String string, Short s) {
        return this.getCurrentConfig().getShort(string, s);
    }

    @Override
    public short getShort(String string) {
        return this.getCurrentConfig().getShort(string);
    }

    @Override
    public String getString(String string, String string2) {
        return this.getCurrentConfig().getString(string, string2);
    }

    @Override
    public String getString(String string) {
        return this.getCurrentConfig().getString(string);
    }

    @Override
    public String[] getStringArray(String string) {
        return this.getCurrentConfig().getStringArray(string);
    }

    @Override
    public boolean isEmpty() {
        return this.getCurrentConfig().isEmpty();
    }

    @Override
    public void setProperty(String string, Object object) {
        if (this.configs != null) {
            this.getCurrentConfig().setProperty(string, object);
        }
    }

    @Override
    public Configuration subset(String string) {
        return this.getCurrentConfig().subset(string);
    }

    @Override
    public HierarchicalConfiguration.Node getRoot() {
        return this.getCurrentConfig().getRoot();
    }

    @Override
    public void setRoot(HierarchicalConfiguration.Node node) {
        if (this.configs != null) {
            this.getCurrentConfig().setRoot(node);
        } else {
            super.setRoot(node);
        }
    }

    @Override
    public ExpressionEngine getExpressionEngine() {
        return super.getExpressionEngine();
    }

    @Override
    public void setExpressionEngine(ExpressionEngine expressionEngine) {
        super.setExpressionEngine(expressionEngine);
    }

    @Override
    public void addNodes(String string, Collection<? extends ConfigurationNode> collection) {
        this.getCurrentConfig().addNodes(string, collection);
    }

    @Override
    public SubnodeConfiguration configurationAt(String string, boolean bl) {
        return this.getCurrentConfig().configurationAt(string, bl);
    }

    @Override
    public SubnodeConfiguration configurationAt(String string) {
        return this.getCurrentConfig().configurationAt(string);
    }

    @Override
    public List<HierarchicalConfiguration> configurationsAt(String string) {
        return this.getCurrentConfig().configurationsAt(string);
    }

    @Override
    public void clearTree(String string) {
        this.getCurrentConfig().clearTree(string);
    }

    @Override
    public int getMaxIndex(String string) {
        return this.getCurrentConfig().getMaxIndex(string);
    }

    @Override
    public Configuration interpolatedConfiguration() {
        return this.getCurrentConfig().interpolatedConfiguration();
    }

    @Override
    public Configuration getSource(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Key must not be null!");
        }
        return this.getCurrentConfig().getSource(string);
    }

    @Override
    public void addConfigurationListener(ConfigurationListener configurationListener) {
        super.addConfigurationListener(configurationListener);
        for (CombinedConfiguration combinedConfiguration : this.configs.values()) {
            combinedConfiguration.addConfigurationListener(configurationListener);
        }
    }

    @Override
    public boolean removeConfigurationListener(ConfigurationListener configurationListener) {
        for (CombinedConfiguration combinedConfiguration : this.configs.values()) {
            combinedConfiguration.removeConfigurationListener(configurationListener);
        }
        return super.removeConfigurationListener(configurationListener);
    }

    @Override
    public Collection<ConfigurationListener> getConfigurationListeners() {
        return super.getConfigurationListeners();
    }

    @Override
    public void clearConfigurationListeners() {
        for (CombinedConfiguration combinedConfiguration : this.configs.values()) {
            combinedConfiguration.clearConfigurationListeners();
        }
        super.clearConfigurationListeners();
    }

    @Override
    public void addErrorListener(ConfigurationErrorListener configurationErrorListener) {
        for (CombinedConfiguration combinedConfiguration : this.configs.values()) {
            combinedConfiguration.addErrorListener(configurationErrorListener);
        }
        super.addErrorListener(configurationErrorListener);
    }

    @Override
    public boolean removeErrorListener(ConfigurationErrorListener configurationErrorListener) {
        for (CombinedConfiguration combinedConfiguration : this.configs.values()) {
            combinedConfiguration.removeErrorListener(configurationErrorListener);
        }
        return super.removeErrorListener(configurationErrorListener);
    }

    @Override
    public void clearErrorListeners() {
        for (CombinedConfiguration combinedConfiguration : this.configs.values()) {
            combinedConfiguration.clearErrorListeners();
        }
        super.clearErrorListeners();
    }

    @Override
    public Collection<ConfigurationErrorListener> getErrorListeners() {
        return super.getErrorListeners();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public void invalidate() {
        this.getCurrentConfig().invalidate();
    }

    public void invalidateAll() {
        if (this.configs == null) {
            return;
        }
        for (CombinedConfiguration combinedConfiguration : this.configs.values()) {
            combinedConfiguration.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object resolveContainerStore(String string) {
        if (recursive.get().booleanValue()) {
            return null;
        }
        recursive.set(Boolean.TRUE);
        try {
            Object object = super.resolveContainerStore(string);
            return object;
        }
        finally {
            recursive.set(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CombinedConfiguration getCurrentConfig() {
        String string = this.localSubst.replace(this.keyPattern);
        CombinedConfiguration combinedConfiguration = (CombinedConfiguration)this.configs.get(string);
        if (combinedConfiguration == null) {
            ConcurrentMap<String, CombinedConfiguration> concurrentMap = this.configs;
            synchronized (concurrentMap) {
                combinedConfiguration = (CombinedConfiguration)this.configs.get(string);
                if (combinedConfiguration == null) {
                    Iterator<Object> iterator;
                    combinedConfiguration = new CombinedConfiguration(this.getNodeCombiner());
                    if (this.loggerName != null && (iterator = LogFactory.getLog(this.loggerName)) != null) {
                        combinedConfiguration.setLogger((Log)((Object)iterator));
                    }
                    combinedConfiguration.setIgnoreReloadExceptions(this.isIgnoreReloadExceptions());
                    combinedConfiguration.setExpressionEngine(this.getExpressionEngine());
                    combinedConfiguration.setDelimiterParsingDisabled(this.isDelimiterParsingDisabled());
                    combinedConfiguration.setConversionExpressionEngine(this.getConversionExpressionEngine());
                    combinedConfiguration.setListDelimiter(this.getListDelimiter());
                    for (ConfigurationErrorListener object : this.getErrorListeners()) {
                        combinedConfiguration.addErrorListener(object);
                    }
                    for (ConfigurationListener configurationListener : this.getConfigurationListeners()) {
                        combinedConfiguration.addConfigurationListener(configurationListener);
                    }
                    combinedConfiguration.setForceReloadCheck(this.isForceReloadCheck());
                    for (ConfigData configData : this.configurations) {
                        combinedConfiguration.addConfiguration(configData.getConfiguration(), configData.getName(), configData.getAt());
                    }
                    this.configs.put(string, combinedConfiguration);
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Returning config for " + string + ": " + combinedConfiguration);
        }
        return combinedConfiguration;
    }

    static class ConfigData {
        private AbstractConfiguration configuration;
        private String name;
        private String at;

        public ConfigData(AbstractConfiguration abstractConfiguration, String string, String string2) {
            this.configuration = abstractConfiguration;
            this.name = string;
            this.at = string2;
        }

        public AbstractConfiguration getConfiguration() {
            return this.configuration;
        }

        public String getName() {
            return this.name;
        }

        public String getAt() {
            return this.at;
        }
    }
}

