/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.sender.MessageSerializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializerFactory;
import com.navercorp.pinpoint.thrift.io.TBaseSerializer;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftMessageSerializer
implements MessageSerializer<byte[]> {
    public static final int UDP_MAX_PACKET_LENGTH = 65507;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TBaseSerializer serializer;
    private final MessageConverter<TBase<?, ?>> messageConverter;

    public ThriftMessageSerializer(MessageConverter<TBase<?, ?>> messageConverter) {
        this(messageConverter, (TBaseSerializer)HeaderTBaseSerializerFactory.DEFAULT_FACTORY.createSerializer());
    }

    public ThriftMessageSerializer(MessageConverter<TBase<?, ?>> messageConverter, TBaseSerializer serializer) {
        this.messageConverter = (MessageConverter)Assert.requireNonNull(messageConverter, (String)"messageConverter must not be null");
        this.serializer = (TBaseSerializer)Assert.requireNonNull((Object)serializer, (String)"serializer must not be null");
    }

    @Override
    public byte[] serializer(Object message) {
        if (message instanceof TBase) {
            TBase tBase = (TBase)message;
            return this.serialize(this.serializer, tBase);
        }
        TBase<?, ?> tBase = this.messageConverter.toMessage(message);
        if (tBase != null) {
            return this.serialize(this.serializer, tBase);
        }
        return null;
    }

    private byte[] serialize(TBaseSerializer serializer, TBase tBase) {
        try {
            return serializer.serialize(tBase);
        }
        catch (TException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Serialize {} failed. Error:{}", new Object[]{tBase, e.getMessage(), e});
            }
            return null;
        }
    }
}

