/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.id;

import com.google.inject.Inject;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.common.util.TransactionId;
import com.navercorp.pinpoint.common.util.TransactionIdUtils;
import com.navercorp.pinpoint.profiler.context.id.DefaultTraceId;
import com.navercorp.pinpoint.profiler.context.id.TraceIdFactory;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;

public class DefaultTraceIdFactory
implements TraceIdFactory {
    private final String agentId;
    private final long agentStartTime;

    @Inject
    public DefaultTraceIdFactory(@AgentId String agentId, @AgentStartTime long agentStartTime) {
        if (agentId == null) {
            throw new NullPointerException("agentId must not be null");
        }
        this.agentId = agentId;
        this.agentStartTime = agentStartTime;
    }

    @Override
    public TraceId newTraceId(long localTransactionId) {
        DefaultTraceId traceId = new DefaultTraceId(this.agentId, this.agentStartTime, localTransactionId);
        return traceId;
    }

    @Override
    public TraceId continueTraceId(String transactionId, long parentSpanId, long spanId, short flags) {
        if (transactionId == null) {
            throw new NullPointerException("transactionId must not be null");
        }
        TransactionId parseId = TransactionIdUtils.parseTransactionId((String)transactionId);
        return new DefaultTraceId(parseId.getAgentId(), parseId.getAgentStartTime(), parseId.getTransactionSequence(), parentSpanId, spanId, flags);
    }
}

