/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.mongo;

import com.mongodb.WriteConcern;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class MongoWriteConcernMapper {
    private final Map<WriteConcern, String> writeConcernMap = this.buildWriteConcern();
    private static final String INVALID = "INVALID_WRITECONCERN";

    private Map<WriteConcern, String> buildWriteConcern() {
        HashMap<WriteConcern, String> writeConcernMap = new HashMap<WriteConcern, String>();
        for (Field f : WriteConcern.class.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !f.getType().equals(WriteConcern.class) || f.getAnnotation(Deprecated.class) != null) continue;
            String value = f.getName();
            try {
                WriteConcern key = (WriteConcern)f.get(null);
                writeConcernMap.put(key, value);
            }
            catch (IllegalAccessException e) {
                PLogger logger = PLoggerFactory.getLogger(this.getClass());
                logger.warn("WriteConcern access error Caused by:" + e.getMessage(), (Throwable)e);
            }
        }
        return writeConcernMap;
    }

    public String getName(WriteConcern writeConcern) {
        String ret = this.writeConcernMap.get(writeConcern);
        if (ret == null) {
            return INVALID;
        }
        return ret;
    }
}

