/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.resttemplate;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.resttemplate.RestTemplateConfig;
import com.navercorp.pinpoint.plugin.resttemplate.RestTemplateConstants;
import com.navercorp.pinpoint.plugin.resttemplate.field.accessor.TraceFutureFlagAccessor;
import java.security.ProtectionDomain;

public class RestTemplatePlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        RestTemplateConfig config = new RestTemplateConfig(context.getConfig());
        if (!config.isPluginEnable()) {
            this.logger.info("Disable resttemplate option. 'profiler.resttemplate=false'");
            return;
        }
        this.transformTemplate.transform("org.springframework.web.client.RestTemplate", (TransformCallback)new RestTemplateTransformer());
        this.transformTemplate.transform("org.springframework.http.client.AbstractClientHttpRequest", (TransformCallback)new HttpRequestTransformer());
        this.transformTemplate.transform("org.springframework.http.client.AbstractAsyncClientHttpRequest", (TransformCallback)new AsyncHttpRequestTransformer());
        this.transformTemplate.transform("org.springframework.util.concurrent.SettableListenableFuture", (TransformCallback)new ListenableFutureTransformer());
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    private static class ListenableFutureTransformer
    implements TransformCallback {
        private ListenableFutureTransformer() {
        }

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
            target.addField(AsyncContextAccessor.class.getName());
            target.addField(TraceFutureFlagAccessor.class.getName());
            InstrumentMethod method = InstrumentUtils.findMethod((InstrumentClass)target, (String)"set", (String[])new String[]{"java.lang.Object"});
            if (method != null) {
                method.addInterceptor("com.navercorp.pinpoint.plugin.resttemplate.interceptor.ListenableFutureInterceptor");
            }
            return target.toBytecode();
        }
    }

    private static class AsyncHttpRequestTransformer
    implements TransformCallback {
        private AsyncHttpRequestTransformer() {
        }

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
            InstrumentMethod executeAsyncMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeAsync", (String[])new String[0]);
            if (executeAsyncMethod != null) {
                executeAsyncMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.resttemplate.interceptor.AsyncHttpRequestInterceptor", "REST_TEMPLATE_SCOPE", ExecutionPolicy.BOUNDARY);
            }
            return target.toBytecode();
        }
    }

    private static class HttpRequestTransformer
    implements TransformCallback {
        private HttpRequestTransformer() {
        }

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
            InstrumentMethod executeMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[0]);
            if (executeMethod != null) {
                executeMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.resttemplate.interceptor.HttpRequestInterceptor", "REST_TEMPLATE_SCOPE", ExecutionPolicy.BOUNDARY);
            }
            return target.toBytecode();
        }
    }

    private static class RestTemplateTransformer
    implements TransformCallback {
        private RestTemplateTransformer() {
        }

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentMethod constructor2;
            InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
            InstrumentMethod constructor1 = target.getConstructor(new String[0]);
            if (constructor1 != null) {
                constructor1.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor", VarArgs.va((Object[])new Object[]{RestTemplateConstants.SERVICE_TYPE}), "REST_TEMPLATE_SCOPE", ExecutionPolicy.BOUNDARY);
            }
            if ((constructor2 = target.getConstructor(new String[]{"java.util.List"})) != null) {
                constructor2.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor", VarArgs.va((Object[])new Object[]{RestTemplateConstants.SERVICE_TYPE}), "REST_TEMPLATE_SCOPE", ExecutionPolicy.BOUNDARY);
            }
            return target.toBytecode();
        }
    }
}

