/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.weblogic;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.weblogic.WeblogicConfiguration;
import com.navercorp.pinpoint.plugin.weblogic.WeblogicDetector;
import java.security.ProtectionDomain;

public class WeblogicPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private TransformTemplate transformTemplate;
    protected PLogger logger = PLoggerFactory.getLogger(this.getClass());

    public void setup(ProfilerPluginSetupContext context) {
        WeblogicConfiguration config = new WeblogicConfiguration(context.getConfig());
        if (!config.isEnable()) {
            this.logger.info("WeblogicPlugin disabled");
            return;
        }
        this.logger.info("WeblogicPlugin config={}", (Object)config);
        context.addApplicationTypeDetector(new ApplicationTypeDetector[]{new WeblogicDetector(config.getBootstrapMains())});
        this.addServletRequestImpl(config);
        this.addServerInterceptor();
        this.addAsyncContextImpl();
    }

    private void addServletRequestImpl(final WeblogicConfiguration config) {
        this.transformTemplate.transform("weblogic.servlet.internal.ServletRequestImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod startAsyncMethodEditor;
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                if (config.isHidePinpointHeader()) {
                    target.weave("com.navercorp.pinpoint.plugin.weblogic.aspect.ServletRequestImplAspect");
                }
                if ((startAsyncMethodEditor = target.getDeclaredMethod("startAsync", new String[]{"javax.servlet.ServletRequest", "javax.servlet.ServletResponse"})) != null) {
                    startAsyncMethodEditor.addInterceptor("com.navercorp.pinpoint.plugin.weblogic.interceptor.ServletRequestImplStartAsyncInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addServerInterceptor() {
        this.transformTemplate.transform("weblogic.servlet.internal.WebAppServletContext", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod handleMethodEditorBuilder = target.getDeclaredMethod("execute", new String[]{"weblogic.servlet.internal.ServletRequestImpl", "weblogic.servlet.internal.ServletResponseImpl"});
                if (handleMethodEditorBuilder != null) {
                    handleMethodEditorBuilder.addInterceptor("com.navercorp.pinpoint.plugin.weblogic.interceptor.WebAppServletContextExecuteInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addAsyncContextImpl() {
        this.transformTemplate.transform("weblogic.servlet.internal.async.AsyncContextImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.weblogic.ResponseGetter", "response");
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

