/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.resin.interceptor;

import com.navercorp.pinpoint.bootstrap.context.ServerMetaDataHolder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;

public class WebAppInterceptor
implements AroundInterceptor {
    private PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;

    public WebAppInterceptor(TraceContext traceContext) {
        this.traceContext = traceContext;
    }

    public void before(Object target, Object[] args) {
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        try {
            if (target instanceof ServletContext) {
                ServletContext servletContext = (ServletContext)target;
                String contextKey = this.extractContextKey(servletContext);
                List<String> loadedJarNames = this.extractLibJars(servletContext);
                if (this.isDebug) {
                    this.logger.debug("{}  jars : {}", (Object)contextKey, (Object)Arrays.toString(loadedJarNames.toArray()));
                }
                this.dispatchLibJars(contextKey, loadedJarNames, servletContext);
            } else {
                this.logger.warn("Webapp loader is not an instance of javax.servlet.ServletContext , target={}", target);
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to dispatch lib jars", (Throwable)e);
        }
    }

    private String extractContextKey(ServletContext webapp) {
        String context = webapp.getContextPath();
        return StringUtils.isEmpty((String)context) ? "/ROOT" : context;
    }

    private List<String> extractLibJarNamesFromURLs(URL[] urls) {
        if (urls == null) {
            return Collections.emptyList();
        }
        ArrayList<String> libJarNames = new ArrayList<String>(urls.length);
        for (URL url : urls) {
            try {
                URI uri = url.toURI();
                String libJarName = this.extractLibJarName(uri);
                if (libJarName.length() <= 0) continue;
                libJarNames.add(libJarName);
            }
            catch (URISyntaxException e) {
                this.logger.warn("Invalid library url found : [{}]", (Object)url, (Object)e);
            }
            catch (Exception e) {
                this.logger.warn("Error extracting library name", (Throwable)e);
            }
        }
        return libJarNames;
    }

    private String extractLibJarName(URI uri) {
        String jarName = uri.toString();
        int lastIndexOfSeparator = jarName.lastIndexOf("/");
        if (lastIndexOfSeparator < 0) {
            return jarName;
        }
        int lastIndexOfExclamatory = jarName.lastIndexOf("!");
        if (lastIndexOfExclamatory == lastIndexOfSeparator - 1) {
            jarName = jarName.substring(0, lastIndexOfExclamatory);
            return jarName.substring(jarName.lastIndexOf("/") + 1);
        }
        if (jarName.startsWith("jar:") || jarName.endsWith(".jar")) {
            return jarName.substring(lastIndexOfSeparator + 1);
        }
        return "";
    }

    private void dispatchLibJars(String contextKey, List<String> libJars, ServletContext webapp) {
        ServerMetaDataHolder holder = this.traceContext.getServerMetaDataHolder();
        holder.addServiceInfo(contextKey, libJars);
        holder.setServerName(webapp.getServerInfo());
        holder.notifyListeners();
    }

    private List<String> extractLibJars(ServletContext webapp) {
        ClassLoader classLoader = webapp.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)classLoader).getURLs();
            return this.extractLibJarNamesFromURLs(urls);
        }
        return Collections.emptyList();
    }
}

