/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.module.SpanDataSender;
import com.navercorp.pinpoint.profiler.context.storage.BufferedStorageFactory;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;
import com.navercorp.pinpoint.profiler.context.storage.TraceLogDelegateStorage;
import com.navercorp.pinpoint.profiler.context.storage.TraceLogDelegateStorageFactory;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageFactoryProvider
implements Provider<StorageFactory> {
    private final ProfilerConfig profilerConfig;
    private final DataSender spanDataSender;

    @Inject
    public StorageFactoryProvider(ProfilerConfig profilerConfig, @SpanDataSender DataSender spanDataSender) {
        this.profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)profilerConfig, (String)"profilerConfig must not be null");
        this.spanDataSender = (DataSender)Assert.requireNonNull((Object)spanDataSender, (String)"spanDataSender must not be null");
    }

    public StorageFactory get() {
        StorageFactory storageFactory = this.newStorageFactory();
        if (this.isTraceLogEnabled()) {
            storageFactory = new TraceLogDelegateStorageFactory(storageFactory);
        }
        return storageFactory;
    }

    private StorageFactory newStorageFactory() {
        if (this.profilerConfig.isIoBufferingEnable()) {
            int ioBufferingBufferSize = this.profilerConfig.getIoBufferingBufferSize();
            return new BufferedStorageFactory(ioBufferingBufferSize, this.spanDataSender);
        }
        return new BufferedStorageFactory(Integer.MAX_VALUE, this.spanDataSender);
    }

    public String toString() {
        return "StorageFactoryProvider{profilerConfig=" + this.profilerConfig + ", spanDataSender=" + this.spanDataSender + '}';
    }

    public boolean isTraceLogEnabled() {
        Logger logger = LoggerFactory.getLogger((String)TraceLogDelegateStorage.class.getName());
        return logger.isTraceEnabled();
    }
}

