/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter.flow.processors;

import com.tapm.starter.AgentClassLoader;
import com.tapm.starter.AgentStarter;
import com.tapm.starter.flow.IProcessor;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessException;
import com.tapm.starter.flow.processors.UpdateResult;
import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import com.tapm.starter.util.JdkAndContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class StartAgentProcessor
implements IProcessor {
    private ILogger logger = LoggerFactory.getLogger("StartAgentProcessor");
    public static final String CONTEXT_UPDATE_RESULT = "context_update_result";
    private volatile ClassLoader tapmClassLoader;

    @Override
    public String process(ProcessContext context) throws ProcessException {
        String pid = (String)context.get("Agent-Application-Pid");
        File agentUpdateLockDir = (File)context.get("Agent-Update-Lock-Directory");
        String agentArgs = (String)context.get("agent_start_args");
        Instrumentation inst = (Instrumentation)context.get("agent_instrumentation");
        String eventId = (String)context.get("update_eventid");
        UpdateResult updateResult = (UpdateResult)context.get(CONTEXT_UPDATE_RESULT);
        Boolean isOneAgent = (Boolean)context.get("isOneAgent");
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("agentArgs", agentArgs);
        if (eventId != null) {
            args.put("eventId", eventId);
            if (updateResult != null) {
                args.put("eventResult", updateResult.getType());
                args.put("eventMessage", updateResult.getMessage());
            } else {
                args.put("eventResult", 0);
            }
        }
        if (isOneAgent == null || !isOneAgent.booleanValue()) {
            try {
                RandomAccessFile pidLockFile = this.createPidLock(pid, agentUpdateLockDir);
                args.put("pidLockFile", pidLockFile);
            }
            catch (Exception e) {
                this.logger.warn("Failed to create PID lock", e);
            }
        }
        try {
            Integer hostPid;
            String podName;
            String processName;
            String oneAgentConfigFile;
            String oneAgentUUID;
            HashMap oneAgentConfigMap;
            String agentDataDir;
            Class<?> agentClass = this.getBootstrapAgentClass();
            String agentLogDir = (String)context.get("agentLogDir");
            if (agentLogDir != null) {
                args.put("agentLogDir", agentLogDir);
            }
            if ((agentDataDir = (String)context.get("agentDataDir")) != null) {
                args.put("agentDataDir", agentDataDir);
            }
            if ((oneAgentConfigMap = (HashMap)context.get("oneAgentConfigMap")) != null) {
                args.put("oneAgentConfigMap", oneAgentConfigMap);
            }
            if ((oneAgentUUID = (String)context.get("oneAgentUUID")) != null) {
                args.put("oneAgentUUID", oneAgentUUID);
            }
            if ((oneAgentConfigFile = (String)context.get("oneAgentConfigFile")) != null) {
                args.put("oneAgentConfigFile", oneAgentConfigFile);
            }
            if ((processName = (String)context.get("processName")) != null) {
                args.put("processName", processName);
            }
            if ((podName = (String)context.get("podName")) != null) {
                args.put("podName", podName);
            }
            if ((hostPid = (Integer)context.get("hostPid")) != null) {
                args.put("hostPid", hostPid);
            }
            args.put("pid", context.get("Agent-Application-Pid"));
            args.put("dockerContainerId", context.get("Docker-Container-Id"));
            this.checkJdkAndContainer(args);
            this.logger.info("Start Tapm agent with parameters: {}", args);
            Method premain = agentClass.getDeclaredMethod("startAgent", Map.class, Instrumentation.class);
            premain.invoke(null, args, inst);
        }
        catch (Throwable e) {
            this.logger.error("Error start up Tapm agent", e);
        }
        return "finished";
    }

    private RandomAccessFile createPidLock(String pid, File agentUpdateLockDir) throws IOException {
        if (!agentUpdateLockDir.exists()) {
            agentUpdateLockDir.mkdirs();
        }
        this.logger.info("Create lock file for this PID {}", pid);
        File pidLockFile = new File(agentUpdateLockDir, pid + ".lock");
        RandomAccessFile pidLockFileAccessor = new RandomAccessFile(pidLockFile, "rw");
        FileChannel channel = pidLockFileAccessor.getChannel();
        channel.lock();
        this.logger.info("The PID({}) lock file was created successfully", pid);
        return pidLockFileAccessor;
    }

    private Class<?> getBootstrapAgentClass() throws Throwable {
        ClassLoader agentLoader = this.loadOrDifineClassLoader();
        return agentLoader.loadClass("com.tapm.bootstrap.BootstrapAgentByStarter");
    }

    private ClassLoader loadOrDifineClassLoader() throws Throwable {
        if (null != this.tapmClassLoader) {
            return this.tapmClassLoader;
        }
        URL agent_path_url = AgentStarter.class.getProtectionDomain().getCodeSource().getLocation();
        URL url = new URL(agent_path_url, "tapm-agent-core.jar");
        this.tapmClassLoader = new AgentClassLoader(url);
        return this.tapmClassLoader;
    }

    private void checkJdkAndContainer(Map<String, Object> args) {
        String[] values;
        HashSet<String> containerSets = new HashSet<String>();
        if (JdkAndContainerUtil.isIbmJdk() && (values = JdkAndContainerUtil.ExcludeClassLoaderEnum.IbmJdk.getValues()) != null && values.length > 0) {
            containerSets.addAll(Arrays.asList(values));
        }
        if (JdkAndContainerUtil.isResin() && (values = JdkAndContainerUtil.ExcludeClassLoaderEnum.Resin.getValues()) != null && values.length > 0) {
            containerSets.addAll(Arrays.asList(values));
        }
        if (JdkAndContainerUtil.isWebLogic() && (values = JdkAndContainerUtil.ExcludeClassLoaderEnum.Weblogic.getValues()) != null && values.length > 0) {
            containerSets.addAll(Arrays.asList(values));
        }
        if (JdkAndContainerUtil.isWebSphere() && (values = JdkAndContainerUtil.ExcludeClassLoaderEnum.WebSphere.getValues()) != null && values.length > 0) {
            containerSets.addAll(Arrays.asList(values));
        }
        args.put("excludeClassLoader", containerSets);
    }
}

