/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.cli;

import com.secnium.iast.thirdparty.org.apache.commons.cli.Option;
import com.secnium.iast.thirdparty.org.apache.commons.cli.OptionGroup;
import com.secnium.iast.thirdparty.org.apache.commons.cli.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Option> shortOpts = new LinkedHashMap<String, Option>();
    private final Map<String, Option> longOpts = new LinkedHashMap<String, Option>();
    private final List<Object> requiredOpts = new ArrayList<Object>();
    private final Map<String, OptionGroup> optionGroups = new LinkedHashMap<String, OptionGroup>();

    public Options addOptionGroup(OptionGroup optionGroup) {
        if (optionGroup.isRequired()) {
            this.requiredOpts.add(optionGroup);
        }
        for (Option option : optionGroup.getOptions()) {
            option.setRequired(false);
            this.addOption(option);
            this.optionGroups.put(option.getKey(), optionGroup);
        }
        return this;
    }

    Collection<OptionGroup> getOptionGroups() {
        return new HashSet<OptionGroup>(this.optionGroups.values());
    }

    public Options addOption(String string, String string2) {
        this.addOption(string, null, false, string2);
        return this;
    }

    public Options addOption(String string, boolean bl, String string2) {
        this.addOption(string, null, bl, string2);
        return this;
    }

    public Options addOption(String string, String string2, boolean bl, String string3) {
        this.addOption(new Option(string, string2, bl, string3));
        return this;
    }

    public Options addRequiredOption(String string, String string2, boolean bl, String string3) {
        Option option = new Option(string, string2, bl, string3);
        option.setRequired(true);
        this.addOption(option);
        return this;
    }

    public Options addOption(Option option) {
        String string = option.getKey();
        if (option.hasLongOpt()) {
            this.longOpts.put(option.getLongOpt(), option);
        }
        if (option.isRequired()) {
            if (this.requiredOpts.contains(string)) {
                this.requiredOpts.remove(this.requiredOpts.indexOf(string));
            }
            this.requiredOpts.add(string);
        }
        this.shortOpts.put(string, option);
        return this;
    }

    public Collection<Option> getOptions() {
        return Collections.unmodifiableCollection(this.helpOptions());
    }

    List<Option> helpOptions() {
        return new ArrayList<Option>(this.shortOpts.values());
    }

    public List getRequiredOptions() {
        return Collections.unmodifiableList(this.requiredOpts);
    }

    public Option getOption(String string) {
        if (this.shortOpts.containsKey(string = Util.stripLeadingHyphens(string))) {
            return this.shortOpts.get(string);
        }
        return this.longOpts.get(string);
    }

    public List<String> getMatchingOptions(String string) {
        string = Util.stripLeadingHyphens(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.longOpts.keySet().contains(string)) {
            return Collections.singletonList(string);
        }
        for (String string2 : this.longOpts.keySet()) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public boolean hasOption(String string) {
        return this.shortOpts.containsKey(string = Util.stripLeadingHyphens(string)) || this.longOpts.containsKey(string);
    }

    public boolean hasLongOption(String string) {
        string = Util.stripLeadingHyphens(string);
        return this.longOpts.containsKey(string);
    }

    public boolean hasShortOption(String string) {
        string = Util.stripLeadingHyphens(string);
        return this.shortOpts.containsKey(string);
    }

    public OptionGroup getOptionGroup(Option option) {
        return this.optionGroups.get(option.getKey());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ Options: [ short ");
        stringBuilder.append(this.shortOpts.toString());
        stringBuilder.append(" ] [ long ");
        stringBuilder.append(this.longOpts);
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

