/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.tree;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.DefaultExpressionEngine;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DefaultConfigurationKey {
    private static final int INITIAL_SIZE = 32;
    private DefaultExpressionEngine expressionEngine;
    private StringBuilder keyBuffer;

    public DefaultConfigurationKey(DefaultExpressionEngine defaultExpressionEngine) {
        this.keyBuffer = new StringBuilder(32);
        this.setExpressionEngine(defaultExpressionEngine);
    }

    public DefaultConfigurationKey(DefaultExpressionEngine defaultExpressionEngine, String string) {
        this.setExpressionEngine(defaultExpressionEngine);
        this.keyBuffer = new StringBuilder(this.trim(string));
    }

    public DefaultExpressionEngine getExpressionEngine() {
        return this.expressionEngine;
    }

    public void setExpressionEngine(DefaultExpressionEngine defaultExpressionEngine) {
        if (defaultExpressionEngine == null) {
            throw new IllegalArgumentException("Expression engine must not be null!");
        }
        this.expressionEngine = defaultExpressionEngine;
    }

    public DefaultConfigurationKey append(String string, boolean bl) {
        String string2 = bl && string != null ? this.escapeDelimiters(string) : string;
        string2 = this.trim(string2);
        if (this.keyBuffer.length() > 0 && !this.isAttributeKey(string) && string2.length() > 0) {
            this.keyBuffer.append(this.getExpressionEngine().getPropertyDelimiter());
        }
        this.keyBuffer.append(string2);
        return this;
    }

    public DefaultConfigurationKey append(String string) {
        return this.append(string, false);
    }

    public DefaultConfigurationKey appendIndex(int n) {
        this.keyBuffer.append(this.getExpressionEngine().getIndexStart());
        this.keyBuffer.append(n);
        this.keyBuffer.append(this.getExpressionEngine().getIndexEnd());
        return this;
    }

    public DefaultConfigurationKey appendAttribute(String string) {
        this.keyBuffer.append(this.constructAttributeKey(string));
        return this;
    }

    public int length() {
        return this.keyBuffer.length();
    }

    public void setLength(int n) {
        this.keyBuffer.setLength(n);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.keyBuffer.toString().equals(object.toString());
    }

    public int hashCode() {
        return String.valueOf(this.keyBuffer).hashCode();
    }

    public String toString() {
        return this.keyBuffer.toString();
    }

    public boolean isAttributeKey(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith(this.getExpressionEngine().getAttributeStart()) && (this.getExpressionEngine().getAttributeEnd() == null || string.endsWith(this.getExpressionEngine().getAttributeEnd()));
    }

    public String constructAttributeKey(String string) {
        if (string == null) {
            return "";
        }
        if (this.isAttributeKey(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getExpressionEngine().getAttributeStart()).append(string);
        if (this.getExpressionEngine().getAttributeEnd() != null) {
            stringBuilder.append(this.getExpressionEngine().getAttributeEnd());
        }
        return stringBuilder.toString();
    }

    public String attributeName(String string) {
        return this.isAttributeKey(string) ? this.removeAttributeMarkers(string) : string;
    }

    public String trimLeft(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        while (this.hasLeadingDelimiter(string2)) {
            string2 = string2.substring(this.getExpressionEngine().getPropertyDelimiter().length());
        }
        return string2;
    }

    public String trimRight(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        while (this.hasTrailingDelimiter(string2)) {
            string2 = string2.substring(0, string2.length() - this.getExpressionEngine().getPropertyDelimiter().length());
        }
        return string2;
    }

    public String trim(String string) {
        return this.trimRight(this.trimLeft(string));
    }

    public KeyIterator iterator() {
        return new KeyIterator();
    }

    private boolean hasTrailingDelimiter(String string) {
        return string.endsWith(this.getExpressionEngine().getPropertyDelimiter()) && (this.getExpressionEngine().getEscapedDelimiter() == null || !string.endsWith(this.getExpressionEngine().getEscapedDelimiter()));
    }

    private boolean hasLeadingDelimiter(String string) {
        return string.startsWith(this.getExpressionEngine().getPropertyDelimiter()) && (this.getExpressionEngine().getEscapedDelimiter() == null || !string.startsWith(this.getExpressionEngine().getEscapedDelimiter()));
    }

    private String removeAttributeMarkers(String string) {
        return string.substring(this.getExpressionEngine().getAttributeStart().length(), string.length() - (this.getExpressionEngine().getAttributeEnd() != null ? this.getExpressionEngine().getAttributeEnd().length() : 0));
    }

    private String unescapeDelimiters(String string) {
        return this.getExpressionEngine().getEscapedDelimiter() == null ? string : StringUtils.replace(string, this.getExpressionEngine().getEscapedDelimiter(), this.getExpressionEngine().getPropertyDelimiter());
    }

    private String escapeDelimiters(String string) {
        return this.getExpressionEngine().getEscapedDelimiter() == null || string.indexOf(this.getExpressionEngine().getPropertyDelimiter()) < 0 ? string : StringUtils.replace(string, this.getExpressionEngine().getPropertyDelimiter(), this.getExpressionEngine().getEscapedDelimiter());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KeyIterator
    implements Cloneable,
    Iterator<Object> {
        private String current;
        private int startIndex;
        private int endIndex;
        private int indexValue;
        private boolean hasIndex;
        private boolean attribute;

        public String nextKey() {
            return this.nextKey(false);
        }

        public String nextKey(boolean bl) {
            String string;
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more key parts!");
            }
            this.hasIndex = false;
            this.indexValue = -1;
            this.current = string = this.findNextIndices();
            this.hasIndex = this.checkIndex(string);
            this.attribute = this.checkAttribute(this.current);
            return this.currentKey(bl);
        }

        @Override
        public boolean hasNext() {
            return this.endIndex < DefaultConfigurationKey.this.keyBuffer.length();
        }

        @Override
        public Object next() {
            return this.nextKey();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported!");
        }

        public String currentKey() {
            return this.currentKey(false);
        }

        public String currentKey(boolean bl) {
            return bl && !this.isPropertyKey() ? DefaultConfigurationKey.this.constructAttributeKey(this.current) : this.current;
        }

        public boolean isAttribute() {
            return this.attribute || this.isAttributeEmulatingMode() && !this.hasNext();
        }

        public boolean isPropertyKey() {
            return !this.attribute;
        }

        public int getIndex() {
            return this.indexValue;
        }

        public boolean hasIndex() {
            return this.hasIndex;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        private String findNextIndices() {
            this.startIndex = this.endIndex;
            while (this.startIndex < DefaultConfigurationKey.this.length() && DefaultConfigurationKey.this.hasLeadingDelimiter(DefaultConfigurationKey.this.keyBuffer.substring(this.startIndex))) {
                this.startIndex += DefaultConfigurationKey.this.getExpressionEngine().getPropertyDelimiter().length();
            }
            if (this.startIndex >= DefaultConfigurationKey.this.length()) {
                this.endIndex = DefaultConfigurationKey.this.length();
                this.startIndex = this.endIndex - 1;
                return DefaultConfigurationKey.this.keyBuffer.substring(this.startIndex, this.endIndex);
            }
            return this.nextKeyPart();
        }

        private String nextKeyPart() {
            int n;
            int n2 = DefaultConfigurationKey.this.keyBuffer.toString().indexOf(DefaultConfigurationKey.this.getExpressionEngine().getAttributeStart(), this.startIndex);
            if (n2 < 0 || n2 == this.startIndex) {
                n2 = DefaultConfigurationKey.this.length();
            }
            if ((n = this.nextDelimiterPos(DefaultConfigurationKey.this.keyBuffer.toString(), this.startIndex, n2)) < 0) {
                n = n2;
            }
            this.endIndex = Math.min(n2, n);
            return DefaultConfigurationKey.this.unescapeDelimiters(DefaultConfigurationKey.this.keyBuffer.substring(this.startIndex, this.endIndex));
        }

        private int nextDelimiterPos(String string, int n, int n2) {
            int n3 = n;
            boolean bl = false;
            do {
                if ((n3 = string.indexOf(DefaultConfigurationKey.this.getExpressionEngine().getPropertyDelimiter(), n3)) < 0 || n3 >= n2) {
                    return -1;
                }
                int n4 = this.escapedPosition(string, n3);
                if (n4 < 0) {
                    bl = true;
                    continue;
                }
                n3 = n4;
            } while (!bl);
            return n3;
        }

        private int escapedPosition(String string, int n) {
            if (DefaultConfigurationKey.this.getExpressionEngine().getEscapedDelimiter() == null) {
                return -1;
            }
            int n2 = this.escapeOffset();
            if (n2 < 0 || n2 > n) {
                return -1;
            }
            int n3 = string.indexOf(DefaultConfigurationKey.this.getExpressionEngine().getEscapedDelimiter(), n - n2);
            if (n3 <= n && n3 >= 0) {
                return n3 + DefaultConfigurationKey.this.getExpressionEngine().getEscapedDelimiter().length();
            }
            return -1;
        }

        private int escapeOffset() {
            return DefaultConfigurationKey.this.getExpressionEngine().getEscapedDelimiter().indexOf(DefaultConfigurationKey.this.getExpressionEngine().getPropertyDelimiter());
        }

        private boolean checkAttribute(String string) {
            if (DefaultConfigurationKey.this.isAttributeKey(string)) {
                this.current = DefaultConfigurationKey.this.removeAttributeMarkers(string);
                return true;
            }
            return false;
        }

        private boolean checkIndex(String string) {
            boolean bl = false;
            try {
                int n;
                int n2 = string.lastIndexOf(DefaultConfigurationKey.this.getExpressionEngine().getIndexStart());
                if (n2 > 0 && (n = string.indexOf(DefaultConfigurationKey.this.getExpressionEngine().getIndexEnd(), n2)) > n2 + 1) {
                    this.indexValue = Integer.parseInt(string.substring(n2 + 1, n));
                    this.current = string.substring(0, n2);
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            return bl;
        }

        private boolean isAttributeEmulatingMode() {
            return DefaultConfigurationKey.this.getExpressionEngine().getAttributeEnd() == null && StringUtils.equals(DefaultConfigurationKey.this.getExpressionEngine().getPropertyDelimiter(), DefaultConfigurationKey.this.getExpressionEngine().getAttributeStart());
        }
    }
}

