/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.BaseConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationUtils;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileSystem;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileSystemBased;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Lock;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.VerifiableOutputStream;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.reloading.InvariantReloadingStrategy;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.reloading.ReloadingStrategy;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileConfiguration
extends BaseConfiguration
implements FileConfiguration,
FileSystemBased {
    public static final int EVENT_RELOAD = 20;
    public static final int EVENT_CONFIG_CHANGED = 21;
    private static final String FILE_SCHEME = "file:";
    protected String fileName;
    protected String basePath;
    protected boolean autoSave;
    protected ReloadingStrategy strategy;
    protected Object reloadLock = new Lock("AbstractFileConfiguration");
    private String encoding;
    private URL sourceURL;
    private int noReload;
    private FileSystem fileSystem = FileSystem.getDefaultFileSystem();

    public AbstractFileConfiguration() {
        this.initReloadingStrategy();
        this.setLogger(LogFactory.getLog(this.getClass()));
        this.addErrorLogListener();
    }

    public AbstractFileConfiguration(String string) throws ConfigurationException {
        this();
        this.setFileName(string);
        this.load();
    }

    public AbstractFileConfiguration(File file) throws ConfigurationException {
        this();
        this.setFile(file);
        if (file.exists()) {
            this.load();
        }
    }

    public AbstractFileConfiguration(URL uRL) throws ConfigurationException {
        this();
        this.setURL(uRL);
        this.load();
    }

    @Override
    public void setFileSystem(FileSystem fileSystem) {
        if (fileSystem == null) {
            throw new NullPointerException("A valid FileSystem must be specified");
        }
        this.fileSystem = fileSystem;
    }

    @Override
    public void resetFileSystem() {
        this.fileSystem = FileSystem.getDefaultFileSystem();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Object getReloadLock() {
        return this.reloadLock;
    }

    @Override
    public void load() throws ConfigurationException {
        if (this.sourceURL != null) {
            this.load(this.sourceURL);
        } else {
            this.load(this.getFileName());
        }
    }

    @Override
    public void load(String string) throws ConfigurationException {
        try {
            URL uRL = ConfigurationUtils.locate(this.fileSystem, this.basePath, string);
            if (uRL == null) {
                throw new ConfigurationException("Cannot locate configuration source " + string);
            }
            this.load(uRL);
        }
        catch (ConfigurationException configurationException) {
            throw configurationException;
        }
        catch (Exception exception) {
            throw new ConfigurationException("Unable to load the configuration file " + string, exception);
        }
    }

    @Override
    public void load(File file) throws ConfigurationException {
        try {
            this.load(ConfigurationUtils.toURL(file));
        }
        catch (ConfigurationException configurationException) {
            throw configurationException;
        }
        catch (Exception exception) {
            throw new ConfigurationException("Unable to load the configuration file " + file, exception);
        }
    }

    @Override
    public void load(URL uRL) throws ConfigurationException {
        if (this.sourceURL == null) {
            if (StringUtils.isEmpty(this.getBasePath())) {
                this.setBasePath(uRL.toString());
            }
            this.sourceURL = uRL;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.fileSystem.getInputStream(uRL);
            this.load(inputStream);
        }
        catch (ConfigurationException configurationException) {
            throw configurationException;
        }
        catch (Exception exception) {
            throw new ConfigurationException("Unable to load the configuration from the URL " + uRL, exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                this.getLogger().warn("Could not close input stream", iOException);
            }
        }
    }

    @Override
    public void load(InputStream inputStream) throws ConfigurationException {
        this.load(inputStream, this.getEncoding());
    }

    @Override
    public void load(InputStream inputStream, String string) throws ConfigurationException {
        InputStreamReader inputStreamReader = null;
        if (string != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ConfigurationException("The requested encoding is not supported, try the default encoding.", unsupportedEncodingException);
            }
        }
        if (inputStreamReader == null) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        this.load(inputStreamReader);
    }

    @Override
    public void save() throws ConfigurationException {
        if (this.getFileName() == null) {
            throw new ConfigurationException("No file name has been set!");
        }
        if (this.sourceURL != null) {
            this.save(this.sourceURL);
        } else {
            this.save(this.fileName);
        }
        this.strategy.init();
    }

    @Override
    public void save(String string) throws ConfigurationException {
        try {
            URL uRL = this.fileSystem.getURL(this.basePath, string);
            if (uRL == null) {
                throw new ConfigurationException("Cannot locate configuration source " + string);
            }
            this.save(uRL);
        }
        catch (ConfigurationException configurationException) {
            throw configurationException;
        }
        catch (Exception exception) {
            throw new ConfigurationException("Unable to save the configuration to the file " + string, exception);
        }
    }

    @Override
    public void save(URL uRL) throws ConfigurationException {
        OutputStream outputStream = null;
        try {
            outputStream = this.fileSystem.getOutputStream(uRL);
            this.save(outputStream);
            if (outputStream instanceof VerifiableOutputStream) {
                ((VerifiableOutputStream)outputStream).verify();
            }
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Could not save to URL " + uRL, iOException);
        }
        finally {
            this.closeSilent(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(File file) throws ConfigurationException {
        OutputStream outputStream = null;
        try {
            outputStream = this.fileSystem.getOutputStream(file);
            this.save(outputStream);
        }
        finally {
            this.closeSilent(outputStream);
        }
    }

    @Override
    public void save(OutputStream outputStream) throws ConfigurationException {
        this.save(outputStream, this.getEncoding());
    }

    @Override
    public void save(OutputStream outputStream, String string) throws ConfigurationException {
        OutputStreamWriter outputStreamWriter = null;
        if (string != null) {
            try {
                outputStreamWriter = new OutputStreamWriter(outputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ConfigurationException("The requested encoding is not supported, try the default encoding.", unsupportedEncodingException);
            }
        }
        if (outputStreamWriter == null) {
            outputStreamWriter = new OutputStreamWriter(outputStream);
        }
        this.save(outputStreamWriter);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String string) {
        if (string != null && string.startsWith(FILE_SCHEME) && !string.startsWith("file://")) {
            string = "file://" + string.substring(FILE_SCHEME.length());
        }
        this.sourceURL = null;
        this.fileName = string;
        this.getLogger().debug("FileName set to " + string);
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setBasePath(String string) {
        if (string != null && string.startsWith(FILE_SCHEME) && !string.startsWith("file://")) {
            string = "file://" + string.substring(FILE_SCHEME.length());
        }
        this.sourceURL = null;
        this.basePath = string;
        this.getLogger().debug("Base path set to " + string);
    }

    @Override
    public File getFile() {
        if (this.getFileName() == null && this.sourceURL == null) {
            return null;
        }
        if (this.sourceURL != null) {
            return ConfigurationUtils.fileFromURL(this.sourceURL);
        }
        return ConfigurationUtils.getFile(this.getBasePath(), this.getFileName());
    }

    @Override
    public void setFile(File file) {
        this.sourceURL = null;
        this.setFileName(file.getName());
        this.setBasePath(file.getParentFile() != null ? file.getParentFile().getAbsolutePath() : null);
    }

    public String getPath() {
        return this.fileSystem.getPath(this.getFile(), this.sourceURL, this.getBasePath(), this.getFileName());
    }

    public void setPath(String string) {
        this.setFile(new File(string));
    }

    URL getSourceURL() {
        return this.sourceURL;
    }

    @Override
    public URL getURL() {
        return this.sourceURL != null ? this.sourceURL : ConfigurationUtils.locate(this.fileSystem, this.getBasePath(), this.getFileName());
    }

    @Override
    public void setURL(URL uRL) {
        this.setBasePath(ConfigurationUtils.getBasePath(uRL));
        this.setFileName(ConfigurationUtils.getFileName(uRL));
        this.sourceURL = uRL;
        this.getLogger().debug("URL set to " + uRL);
    }

    @Override
    public void setAutoSave(boolean bl) {
        this.autoSave = bl;
    }

    @Override
    public boolean isAutoSave() {
        return this.autoSave;
    }

    protected void possiblySave() {
        if (this.autoSave && this.fileName != null) {
            try {
                this.save();
            }
            catch (ConfigurationException configurationException) {
                throw new ConfigurationRuntimeException("Failed to auto-save", configurationException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProperty(String string, Object object) {
        Object object2 = this.reloadLock;
        synchronized (object2) {
            super.addProperty(string, object);
            this.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String string, Object object) {
        Object object2 = this.reloadLock;
        synchronized (object2) {
            super.setProperty(string, object);
            this.possiblySave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearProperty(String string) {
        Object object = this.reloadLock;
        synchronized (object) {
            super.clearProperty(string);
            this.possiblySave();
        }
    }

    @Override
    public ReloadingStrategy getReloadingStrategy() {
        return this.strategy;
    }

    @Override
    public void setReloadingStrategy(ReloadingStrategy reloadingStrategy) {
        this.strategy = reloadingStrategy;
        reloadingStrategy.setConfiguration(this);
        reloadingStrategy.init();
    }

    @Override
    public void reload() {
        this.reload(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reload(boolean bl) {
        Object object = this.reloadLock;
        synchronized (object) {
            if (this.noReload != 0) return true;
            try {
                this.enterNoReload();
                if (!this.strategy.reloadingRequired()) return true;
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("Reloading configuration. URL is " + this.getURL());
                }
                this.refresh();
                this.strategy.reloadingPerformed();
            }
            catch (Exception exception) {
                this.fireError(20, null, null, exception);
                if (!bl) return true;
                boolean bl2 = false;
                return bl2;
            }
            finally {
                this.exitNoReload();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws ConfigurationException {
        this.fireEvent(20, null, this.getURL(), true);
        this.setDetailEvents(false);
        boolean bl = this.isAutoSave();
        this.setAutoSave(false);
        try {
            this.clear();
            this.load();
        }
        finally {
            this.setAutoSave(bl);
            this.setDetailEvents(true);
        }
        this.fireEvent(20, null, this.getURL(), false);
    }

    public void configurationChanged() {
        this.fireEvent(21, null, this.getURL(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enterNoReload() {
        Object object = this.reloadLock;
        synchronized (object) {
            ++this.noReload;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitNoReload() {
        Object object = this.reloadLock;
        synchronized (object) {
            if (this.noReload > 0) {
                --this.noReload;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireEvent(int n, String string, Object object, boolean bl) {
        this.enterNoReload();
        try {
            super.fireEvent(n, string, object, bl);
        }
        finally {
            this.exitNoReload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(String string) {
        Object object = this.reloadLock;
        synchronized (object) {
            this.reload();
            return super.getProperty(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.reload();
        Object object = this.reloadLock;
        synchronized (object) {
            return super.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String string) {
        this.reload();
        Object object = this.reloadLock;
        synchronized (object) {
            return super.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getKeys() {
        this.reload();
        LinkedList<String> linkedList = new LinkedList<String>();
        this.enterNoReload();
        try {
            Iterator<String> iterator = super.getKeys();
            while (iterator.hasNext()) {
                linkedList.add(iterator.next());
            }
            iterator = linkedList.iterator();
            return iterator;
        }
        finally {
            this.exitNoReload();
        }
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public Object clone() {
        AbstractFileConfiguration abstractFileConfiguration = (AbstractFileConfiguration)super.clone();
        abstractFileConfiguration.setBasePath(null);
        abstractFileConfiguration.setFileName(null);
        abstractFileConfiguration.initReloadingStrategy();
        return abstractFileConfiguration;
    }

    private void initReloadingStrategy() {
        this.setReloadingStrategy(new InvariantReloadingStrategy());
    }

    protected void closeSilent(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            this.getLogger().warn("Could not close output stream", iOException);
        }
    }
}

