/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.resolver.condition;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.resolver.condition.Condition;
import com.navercorp.pinpoint.common.util.StringUtils;

public class ClassResourceCondition
implements Condition<String> {
    private static final String CLASS_EXTENSION = ".class";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass().getName());

    private String getClassNameAsResource(String className) {
        String classNameAsResource = className.replace('.', '/');
        return classNameAsResource.endsWith(CLASS_EXTENSION) ? classNameAsResource : classNameAsResource.concat(CLASS_EXTENSION);
    }

    @Override
    public boolean check(String requiredClass) {
        if (StringUtils.isEmpty((String)requiredClass)) {
            return false;
        }
        String classNameAsResource = this.getClassNameAsResource(requiredClass);
        if (ClassLoader.getSystemResource(classNameAsResource) != null) {
            this.logger.debug("Resource found - [{}]", (Object)classNameAsResource);
            return true;
        }
        this.logger.debug("Resource not found - [{}]", (Object)classNameAsResource);
        return false;
    }
}

