/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.ning.asynchttpclient;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.plugin.ning.asynchttpclient.NingAsyncHttpClientPluginConfig;
import java.security.ProtectionDomain;

public class NingAsyncHttpClientPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        NingAsyncHttpClientPluginConfig config = new NingAsyncHttpClientPluginConfig(context.getConfig());
        if (!config.isEnable()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("NingAsyncHttpClientPlugin disabled");
            }
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Add NingAsyncHttpClientPlugin {}", (Object)config);
        }
        this.logger.debug("Add AsyncHttpClient(1.8.x ~ 1.9.x)");
        this.addAsyncHttpClientTransformer();
        this.logger.debug("Add DefaultAsyncHttpClient(2.x ~");
        this.addDefaultAsyncHttpClientTransformer();
    }

    private void addAsyncHttpClientTransformer() {
        this.transformTemplate.transform("com.ning.http.client.AsyncHttpClient", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod executeRequestMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeRequest", (String[])new String[]{"com.ning.http.client.Request", "com.ning.http.client.AsyncHandler"});
                executeRequestMethod.addInterceptor("com.navercorp.pinpoint.plugin.ning.asynchttpclient.interceptor.ExecuteRequestInterceptor");
                return target.toBytecode();
            }
        });
    }

    private void addDefaultAsyncHttpClientTransformer() {
        this.transformTemplate.transform("org.asynchttpclient.DefaultAsyncHttpClient", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod executeRequestMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"org.asynchttpclient.Request", "org.asynchttpclient.AsyncHandler"});
                executeRequestMethod.addInterceptor("com.navercorp.pinpoint.plugin.ning.asynchttpclient.interceptor.ExecuteInterceptor");
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

