/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.PipelineFactory;
import com.navercorp.pinpoint.rpc.client.ClientHandlerFactory;
import com.navercorp.pinpoint.rpc.client.ClientOption;
import com.navercorp.pinpoint.rpc.client.Closed;
import com.navercorp.pinpoint.rpc.client.Connection;
import com.navercorp.pinpoint.rpc.client.PinpointClient;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandler;
import com.navercorp.pinpoint.rpc.client.SocketAddressProvider;
import com.navercorp.pinpoint.rpc.client.SocketOption;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory {
    private final Timer connectTimer;
    private final Closed closed;
    private final ChannelFactory channelFactory;
    private final ClientHandlerFactory clientHandlerFactory;
    private final SocketOption socketOption;
    private final ClientOption clientOption;
    private final PipelineFactory pipelineFactory;

    ConnectionFactory(Timer connectTimer, Closed closed, ChannelFactory channelFactory, SocketOption socketOption, ClientOption clientOption, ClientHandlerFactory clientHandlerFactory, PipelineFactory pipelineFactory) {
        this.connectTimer = (Timer)Assert.requireNonNull((Object)connectTimer, (String)"connectTimer must not be null");
        this.closed = (Closed)Assert.requireNonNull((Object)closed, (String)"release must not be null");
        this.channelFactory = (ChannelFactory)Assert.requireNonNull((Object)channelFactory, (String)"channelFactory must not be null");
        this.socketOption = (SocketOption)Assert.requireNonNull((Object)socketOption, (String)"option must not be null");
        this.clientOption = (ClientOption)Assert.requireNonNull((Object)clientOption, (String)"connectTimer must not be null");
        this.clientHandlerFactory = (ClientHandlerFactory)Assert.requireNonNull((Object)clientHandlerFactory, (String)"clientHandlerFactory must not be null");
        this.pipelineFactory = (PipelineFactory)Assert.requireNonNull((Object)pipelineFactory, (String)"pipelineFactory must not be null");
    }

    public boolean isClosed() {
        return this.closed.isClosed();
    }

    public Connection connect(SocketAddressProvider remoteAddressProvider, boolean reconnect) {
        Connection connection = new Connection(this, this.socketOption, this.channelFactory, this.clientHandlerFactory);
        connection.connect(remoteAddressProvider, reconnect, this.pipelineFactory);
        return connection;
    }

    public void reconnect(PinpointClient pinpointClient, SocketAddressProvider socketAddressProvider) {
        ConnectEvent connectEvent = new ConnectEvent(this, socketAddressProvider, pinpointClient);
        this.connectTimer.newTimeout((TimerTask)connectEvent, this.clientOption.getReconnectDelay(), TimeUnit.MILLISECONDS);
    }

    private static class ConnectEvent
    implements TimerTask {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final ConnectionFactory connectionFactory;
        private final SocketAddressProvider socketAddressProvider;
        private final PinpointClient pinpointClient;

        private ConnectEvent(ConnectionFactory connectionFactory, SocketAddressProvider socketAddressProvider, PinpointClient pinpointClient) {
            this.connectionFactory = (ConnectionFactory)Assert.requireNonNull((Object)connectionFactory, (String)"connectionFactory must not be null");
            this.socketAddressProvider = (SocketAddressProvider)Assert.requireNonNull((Object)socketAddressProvider, (String)"socketAddressProvider must not be null");
            this.pinpointClient = (PinpointClient)Assert.requireNonNull((Object)pinpointClient, (String)"pinpointClient must not be null");
        }

        public void run(Timeout timeout) {
            if (timeout.isCancelled()) {
                return;
            }
            if (this.pinpointClient.isClosed()) {
                this.logger.debug("pinpointClient is already closed.");
                return;
            }
            this.logger.warn("try reconnect. connectAddress:{}", (Object)this.socketAddressProvider);
            Connection connection = this.connectionFactory.connect(this.socketAddressProvider, true);
            final PinpointClientHandler pinpointClientHandler = connection.getPinpointClientHandler();
            pinpointClientHandler.setPinpointClient(this.pinpointClient);
            ChannelFuture channelFuture = connection.getConnectFuture();
            channelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        Channel channel = future.getChannel();
                        ConnectEvent.this.logger.info("reconnect success {}, {}", (Object)ConnectEvent.this.socketAddressProvider, (Object)channel);
                        ConnectEvent.this.pinpointClient.reconnectSocketHandler(pinpointClientHandler);
                    } else if (!ConnectEvent.this.pinpointClient.isClosed()) {
                        ConnectEvent.this.connectionFactory.reconnect(ConnectEvent.this.pinpointClient, ConnectEvent.this.socketAddressProvider);
                    } else {
                        ConnectEvent.this.logger.info("pinpointClient is closed. stop reconnect.");
                    }
                }
            });
        }
    }
}

