/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.rpc.util.ListUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionedByteBufferLocator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final byte[] baseBuffer;
    private final List<Index> partitionIndexList;
    private final int partitionedBufferCapacity;

    private PartitionedByteBufferLocator(byte[] buffer, List<Index> partitionIndexList) {
        if (buffer == null) {
            throw new NullPointerException("buffer must not be null.");
        }
        if (CollectionUtils.isEmpty(partitionIndexList)) {
            throw new NullPointerException("buffer must not be null or zero.");
        }
        Index firstPartitionIndex = (Index)ListUtils.getFirst(partitionIndexList);
        Index lastPartitionIndex = (Index)ListUtils.getLast(partitionIndexList);
        int partitionedBufferCapacity = lastPartitionIndex.getEndPosition() - firstPartitionIndex.getStartPosition();
        if (partitionedBufferCapacity > buffer.length) {
            throw new IllegalArgumentException("partitionedBufferCapacity(" + partitionedBufferCapacity + ") > bufferCapacity(" + buffer.length + ").");
        }
        if (lastPartitionIndex.getEndPosition() > buffer.length) {
            throw new IllegalArgumentException("lastPartitionEndPosition(" + lastPartitionIndex.getEndPosition() + ") > bufferCapacity(" + buffer.length + ").");
        }
        this.baseBuffer = buffer;
        this.partitionIndexList = new ArrayList<Index>(partitionIndexList);
        this.partitionedBufferCapacity = partitionedBufferCapacity;
    }

    public int getPartitionedCount() {
        return this.partitionIndexList.size();
    }

    public int getTotalByteBufferCapacity() {
        return this.partitionedBufferCapacity;
    }

    public int getByteBufferCapacity(int partitionIndex) {
        if (partitionIndex < 0) {
            throw new IllegalArgumentException("partitionIndex = " + partitionIndex);
        }
        if (partitionIndex >= this.getPartitionedCount()) {
            throw new IllegalArgumentException("partitionIndex(" + partitionIndex + ") >= partitionedCount(" + this.getPartitionedCount() + ").");
        }
        return this.partitionIndexList.get(partitionIndex).getCapacity();
    }

    public int getByteBufferCapacity(int fromPartitionIndex, int toPartitionIndex) {
        this.checkRangeValidation(fromPartitionIndex, toPartitionIndex, this.getPartitionedCount());
        int capacity = 0;
        for (int i = fromPartitionIndex; i < toPartitionIndex; ++i) {
            capacity += this.partitionIndexList.get(i).getCapacity();
        }
        return capacity;
    }

    public ByteBuffer getByteBuffer() {
        return this.getByteBuffer(0, this.getPartitionedCount() - 1);
    }

    public ByteBuffer getByteBuffer(int partitionIndex) {
        if (partitionIndex < 0) {
            throw new IllegalArgumentException("partitionIndex = " + partitionIndex);
        }
        if (partitionIndex >= this.getPartitionedCount()) {
            throw new IllegalArgumentException("partitionIndex(" + partitionIndex + ") >= partitionedCount(" + this.getPartitionedCount() + ").");
        }
        Index fromIndex = this.partitionIndexList.get(partitionIndex);
        Index toIndex = this.partitionIndexList.get(partitionIndex);
        int startPosition = fromIndex.getStartPosition();
        int endPosition = toIndex.getEndPosition();
        this.logger.debug("getByteBuffer baseBuffer-length:{}, {}~{}.", new Object[]{this.baseBuffer.length, startPosition, endPosition});
        return ByteBuffer.wrap(this.baseBuffer, fromIndex.getStartPosition(), toIndex.getEndPosition() - fromIndex.getStartPosition());
    }

    public ByteBuffer getByteBuffer(int fromPartitionIndex, int toPartitionIndex) {
        this.checkRangeValidation(fromPartitionIndex, toPartitionIndex, this.getPartitionedCount());
        Index fromIndex = this.partitionIndexList.get(fromPartitionIndex);
        Index toIndex = this.partitionIndexList.get(toPartitionIndex);
        int startPosition = fromIndex.getStartPosition();
        int endPosition = toIndex.getEndPosition();
        this.logger.debug("getByteBuffer baseBuffer-length:{}, {}~{}.", new Object[]{this.baseBuffer.length, startPosition, endPosition});
        return ByteBuffer.wrap(this.baseBuffer, fromIndex.getStartPosition(), toIndex.getEndPosition() - fromIndex.getStartPosition());
    }

    private void checkRangeValidation(int fromPartitionIndex, int toPartitionIndex, int partitionedCount) {
        if (fromPartitionIndex < 0) {
            throw new IllegalArgumentException("fromPartitionIndex = " + fromPartitionIndex);
        }
        if (fromPartitionIndex > toPartitionIndex) {
            throw new IllegalArgumentException("fromPartitionIndex(" + fromPartitionIndex + ") > toPartitionIndex(" + toPartitionIndex + ").");
        }
        if (toPartitionIndex >= partitionedCount) {
            throw new IllegalArgumentException("toPartitionIndex(" + toPartitionIndex + ") >= partitionedCount(" + partitionedCount + ").");
        }
    }

    public boolean isLastPartitionIndex(int partitionIndex) {
        return partitionIndex == this.partitionIndexList.size() - 1;
    }

    public String toString() {
        return "PartitionedByteBufferLocator [baseBuffer-length=" + this.baseBuffer.length + ", partitionedCount=" + this.partitionIndexList.size() + ", partitionedBufferCapacity=" + this.partitionedBufferCapacity + "]";
    }

    static class Index {
        private final int startPosition;
        private final int endPosition;
        private final int capacity;

        Index(int startPosition, int endPosition) {
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.capacity = endPosition - startPosition;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public int getEndPosition() {
            return this.endPosition;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public String toString() {
            return "Index [startPosition=" + this.startPosition + ", endPosition=" + this.endPosition + ", capacity=" + this.capacity + "]";
        }
    }

    public static class Builder {
        private byte[] buffer;
        private List<Index> indexList = new ArrayList<Index>();

        public void setBuffer(byte[] buffer) {
            this.buffer = buffer;
        }

        public void addIndex(List<Index> indexList) {
            if (indexList == null) {
                return;
            }
            for (Index index : indexList) {
                this.addIndex(index);
            }
        }

        public void addIndex(int startBufferPosition, int endBufferPosition) {
            this.addIndex(new Index(startBufferPosition, endBufferPosition));
        }

        public void addIndex(Index index) {
            Index lastPartitionIndex = (Index)ListUtils.getLast(this.indexList);
            int partitionedEndPosition = 0;
            if (lastPartitionIndex != null) {
                partitionedEndPosition = lastPartitionIndex.getEndPosition();
            }
            this.chechRangeValidation(index, partitionedEndPosition);
            this.indexList.add(index);
        }

        private void chechRangeValidation(Index index, int partitionedEndPosition) {
            int startPosition = index.getStartPosition();
            int endPosition = index.getEndPosition();
            if (startPosition < 0) {
                throw new IllegalArgumentException("startPosition = " + startPosition);
            }
            if (startPosition > endPosition) {
                throw new IllegalArgumentException("startPosition(" + startPosition + ") > endPosition(" + endPosition + ").");
            }
            if (startPosition != partitionedEndPosition) {
                throw new IllegalArgumentException("support only stream buffer index. startPosition(" + startPosition + ") != partitionedEndPosition(" + partitionedEndPosition + ").");
            }
        }

        public PartitionedByteBufferLocator build() {
            return new PartitionedByteBufferLocator(this.buffer, this.indexList);
        }
    }
}

