/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.cpu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.UnsupportedMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.cpu.DefaultCpuLoadMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.cpu.CpuLoadMetric;
import com.navercorp.pinpoint.thrift.dto.TCpuLoad;

public class CpuLoadMetricCollectorProvider
implements Provider<AgentStatMetricCollector<TCpuLoad>> {
    private final CpuLoadMetric cpuLoadMetric;

    @Inject
    public CpuLoadMetricCollectorProvider(CpuLoadMetric cpuLoadMetric) {
        this.cpuLoadMetric = (CpuLoadMetric)Assert.requireNonNull((Object)cpuLoadMetric, (String)"cpuLoadMetric must not be null");
    }

    public AgentStatMetricCollector<TCpuLoad> get() {
        if (this.cpuLoadMetric == CpuLoadMetric.UNSUPPORTED_CPU_LOAD_METRIC) {
            return new UnsupportedMetricCollector<TCpuLoad>();
        }
        return new DefaultCpuLoadMetricCollector(this.cpuLoadMetric);
    }
}

