/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.rabbitmq.client;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.instrument.ClassFilters;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.BasicMethodInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.rabbitmq.client.RabbitMQClientConstants;
import com.navercorp.pinpoint.plugin.rabbitmq.client.RabbitMQClientPluginConfig;
import java.security.ProtectionDomain;
import java.util.List;

public class RabbitMQClientPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        RabbitMQClientPluginConfig config = new RabbitMQClientPluginConfig(context.getConfig());
        if (!config.isTraceRabbitMQClient()) {
            return;
        }
        this.addCommonEditors(config.isTraceRabbitMQClientProducer(), config.isTraceRabbitMQClientConsumer());
        if (config.isTraceRabbitMQClientProducer()) {
            this.addAmqpBasicPropertiesEditor();
        }
        if (config.isTraceRabbitMQClientConsumer()) {
            this.addAMQChannelEditor(config.getExcludeExchangeFilter());
            this.addConsumerDispatchEditor(config.getExcludeExchangeFilter());
            this.addConsumerEditors();
            this.addCustomConsumerEditors(config.getConsumerClasses());
        }
        this.addSpringAmqpSupport(config.isTraceRabbitMQClientProducer(), config.isTraceRabbitMQClientConsumer());
    }

    private void addAmqpBasicPropertiesEditor() {
        this.transformTemplate.transform("com.rabbitmq.client.AMQP$BasicProperties", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addSetter("com.navercorp.pinpoint.plugin.rabbitmq.client.field.setter.HeadersFieldSetter", "headers");
                return target.toBytecode();
            }
        });
    }

    private void addCommonEditors(boolean traceProducer, boolean traceConsumer) {
        if (!traceProducer && !traceConsumer) {
            return;
        }
        this.transformTemplate.transform("com.rabbitmq.client.impl.ChannelN", (TransformCallback)new ChannelTransformCallback(traceProducer, traceConsumer));
        this.transformTemplate.transform("com.rabbitmq.client.impl.recovery.AutorecoveringChannel", (TransformCallback)new ChannelTransformCallback(traceProducer, traceConsumer));
        this.transformTemplate.transform("com.rabbitmq.client.impl.SocketFrameHandler", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod constructor2;
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.rabbitmq.client.field.accessor.LocalAddressAccessor");
                target.addField("com.navercorp.pinpoint.plugin.rabbitmq.client.field.accessor.RemoteAddressAccessor");
                InstrumentMethod constructor1 = target.getConstructor(new String[]{"java.net.Socket"});
                if (constructor1 != null) {
                    constructor1.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.SocketFrameHandlerConstructInterceptor", "rabbitmqFrameHandlerCreationScope");
                }
                if ((constructor2 = target.getConstructor(new String[]{"java.net.Socket", "java.util.concurrent.ExecutorService"})) != null) {
                    constructor2.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.SocketFrameHandlerConstructInterceptor", "rabbitmqFrameHandlerCreationScope");
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("com.rabbitmq.client.impl.nio.SocketChannelFrameHandler", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.rabbitmq.client.field.accessor.LocalAddressAccessor");
                target.addField("com.navercorp.pinpoint.plugin.rabbitmq.client.field.accessor.RemoteAddressAccessor");
                InstrumentMethod constructor = target.getConstructor(new String[]{"com.rabbitmq.client.impl.nio.SocketChannelFrameHandlerState"});
                if (constructor != null) {
                    constructor.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.SocketChannelFrameHandlerConstructInterceptor", "rabbitmqFrameHandlerCreationScope");
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("com.rabbitmq.client.Envelope", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("com.rabbitmq.client.impl.AMQCommand", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod constructor = target.getConstructor(new String[]{"com.rabbitmq.client.Method", "com.rabbitmq.client.impl.AMQContentHeader", "byte[]"});
                if (constructor != null) {
                    constructor.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.AMQCommandConstructInterceptor", "rabbitmqProducerScope", ExecutionPolicy.INTERNAL);
                }
                return target.toBytecode();
            }
        });
    }

    private void addAMQChannelEditor(final Filter<String> excludeExchangeFilter) {
        this.transformTemplate.transform("com.rabbitmq.client.impl.AMQChannel", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod handleCompleteInboundCommand = target.getDeclaredMethod("handleCompleteInboundCommand", new String[]{"com.rabbitmq.client.impl.AMQCommand"});
                if (handleCompleteInboundCommand != null) {
                    handleCompleteInboundCommand.addInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.RabbitMQConsumerHandleCompleteInboundCommandInterceptor", VarArgs.va((Object[])new Object[]{excludeExchangeFilter}));
                }
                return target.toBytecode();
            }
        });
    }

    private void addConsumerDispatchEditor(final Filter<String> excludeExchangeFilter) {
        this.transformTemplate.transform("com.rabbitmq.client.impl.ConsumerDispatcher", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod handleDelivery = target.getDeclaredMethod("handleDelivery", new String[]{"com.rabbitmq.client.Consumer", "java.lang.String", "com.rabbitmq.client.Envelope", "com.rabbitmq.client.AMQP$BasicProperties", "byte[]"});
                if (handleDelivery == null) {
                    return null;
                }
                handleDelivery.addInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.RabbitMQConsumerDispatchInterceptor", VarArgs.va((Object[])new Object[]{excludeExchangeFilter}));
                target.addGetter("com.navercorp.pinpoint.plugin.rabbitmq.client.field.getter.ChannelGetter", "channel");
                return target.toBytecode();
            }
        });
    }

    private boolean addConsumerHandleDeliveryInterceptor(InstrumentClass target) throws InstrumentException {
        if (target == null) {
            return false;
        }
        InstrumentMethod handleDelivery = target.getDeclaredMethod("handleDelivery", new String[]{"java.lang.String", "com.rabbitmq.client.Envelope", "com.rabbitmq.client.AMQP$BasicProperties", "byte[]"});
        if (handleDelivery == null) {
            return false;
        }
        handleDelivery.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.ConsumerHandleDeliveryInterceptor", "rabbitmqConsumerScope");
        return true;
    }

    private void addConsumerEditors() {
        this.transformTemplate.transform("com.rabbitmq.client.DefaultConsumer", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (RabbitMQClientPlugin.this.addConsumerHandleDeliveryInterceptor(target)) {
                    return target.toBytecode();
                }
                return null;
            }
        });
        this.transformTemplate.transform("com.rabbitmq.client.QueueingConsumer$Delivery", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod constructor = target.getConstructor(new String[]{"com.rabbitmq.client.Envelope", "com.rabbitmq.client.AMQP$BasicProperties", "byte[]"});
                if (constructor == null) {
                    return null;
                }
                constructor.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.DeliveryConstructInterceptor", "rabbitmqConsumerScope", ExecutionPolicy.INTERNAL);
                target.addField(AsyncContextAccessor.class.getName());
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("com.rabbitmq.client.QueueingConsumer", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (RabbitMQClientPlugin.this.addConsumerHandleDeliveryInterceptor(target)) {
                    InstrumentMethod handle;
                    InstrumentMethod nextDeliveryTimeout;
                    InstrumentMethod nextDelivery = target.getDeclaredMethod("nextDelivery", new String[0]);
                    if (nextDelivery != null) {
                        nextDelivery.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.QueueingConsumerOnNextInterceptor", "rabbitmqConsumerScope");
                    }
                    if ((nextDeliveryTimeout = target.getDeclaredMethod("nextDelivery", new String[]{"long"})) != null) {
                        nextDeliveryTimeout.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.QueueingConsumerOnNextInterceptor", "rabbitmqConsumerScope");
                    }
                    if ((handle = target.getDeclaredMethod("handle", new String[]{"com.rabbitmq.client.QueueingConsumer$Delivery"})) != null) {
                        handle.addInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.QueueingConsumerHandleInterceptor");
                    }
                    return target.toBytecode();
                }
                return null;
            }
        });
    }

    private void addCustomConsumerEditors(List<String> customConsumers) {
        for (String customConsumer : customConsumers) {
            this.transformTemplate.transform(customConsumer, new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                    if (RabbitMQClientPlugin.this.addConsumerHandleDeliveryInterceptor(target)) {
                        return target.toBytecode();
                    }
                    for (InstrumentClass potentialConsumer : target.getNestedClasses(ClassFilters.ACCEPT_ALL)) {
                        if (!potentialConsumer.hasMethod("handleDelivery", new String[]{"java.lang.String", "com.rabbitmq.client.Envelope", "com.rabbitmq.client.AMQP$BasicProperties", "byte[]"})) continue;
                        instrumentor.transform(loader, potentialConsumer.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (RabbitMQClientPlugin.this.addConsumerHandleDeliveryInterceptor(target)) {
                                    return target.toBytecode();
                                }
                                return null;
                            }
                        });
                    }
                    return null;
                }
            });
        }
    }

    private void addSpringAmqpSupport(boolean traceProducer, final boolean traceConsumer) {
        if (!traceProducer && !traceConsumer) {
            return;
        }
        final MethodFilter publicApiFilter = MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"execute", "convertAndSend", "convertSendAndReceive", "convertSendAndReceiveAsType", "correlationConvertAndSend", "doSend", "send", "sendAndReceive", "receive", "receiveAndConvert", "receiveAndReply"}), MethodFilters.modifier((int)1)});
        this.transformTemplate.transform("org.springframework.amqp.rabbit.core.RabbitTemplate", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                for (InstrumentMethod publicApi : target.getDeclaredMethods(publicApiFilter)) {
                    publicApi.addScopedInterceptor(BasicMethodInterceptor.class.getName(), VarArgs.va((Object[])new Object[]{RabbitMQClientConstants.RABBITMQ_CLIENT_INTERNAL}), "rabbitmqTemplateApiScope");
                }
                InstrumentMethod invoke = target.getDeclaredMethod("invoke", new String[]{"org.springframework.amqp.rabbit.core.RabbitOperations$OperationsCallback"});
                if (invoke != null) {
                    invoke.addInterceptor(BasicMethodInterceptor.class.getName(), VarArgs.va((Object[])new Object[]{RabbitMQClientConstants.RABBITMQ_CLIENT_INTERNAL}));
                }
                if (traceConsumer && !RabbitMQClientPlugin.this.addConsumerHandleDeliveryInterceptor(target)) {
                    for (InstrumentClass potentialConsumer : target.getNestedClasses(ClassFilters.ACCEPT_ALL)) {
                        if (!potentialConsumer.hasMethod("handleDelivery", new String[]{"java.lang.String", "com.rabbitmq.client.Envelope", "com.rabbitmq.client.AMQP$BasicProperties", "byte[]"})) continue;
                        instrumentor.transform(loader, potentialConsumer.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                if (RabbitMQClientPlugin.this.addConsumerHandleDeliveryInterceptor(target)) {
                                    return target.toBytecode();
                                }
                                return null;
                            }
                        });
                    }
                }
                return target.toBytecode();
            }
        });
        if (traceConsumer) {
            this.transformTemplate.transform("org.springframework.amqp.core.Message", new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                    target.addField(AsyncContextAccessor.class.getName());
                    return target.toBytecode();
                }
            });
            this.transformTemplate.transform("org.springframework.amqp.rabbit.listener.BlockingQueueConsumer$Delivery", new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentMethod constructor2;
                    InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                    InstrumentMethod constructor1 = target.getConstructor(new String[]{"com.rabbitmq.client.Envelope", "com.rabbitmq.client.AMQP$BasicProperties", "byte[]"});
                    if (constructor1 != null) {
                        constructor1.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.DeliveryConstructInterceptor", "rabbitmqConsumerScope", ExecutionPolicy.INTERNAL);
                    }
                    if ((constructor2 = target.getConstructor(new String[]{"java.lang.String", "com.rabbitmq.client.Envelope", "com.rabbitmq.client.AMQP$BasicProperties", "byte[]"})) != null) {
                        constructor2.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.DeliveryConstructInterceptor", "rabbitmqConsumerScope", ExecutionPolicy.INTERNAL);
                    }
                    target.addField(AsyncContextAccessor.class.getName());
                    return target.toBytecode();
                }
            });
            this.transformTemplate.transform("org.springframework.amqp.rabbit.support.Delivery", new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentMethod constructor_2_1_0;
                    InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                    InstrumentMethod constructor = target.getConstructor(new String[]{"java.lang.String", "com.rabbitmq.client.Envelope", "com.rabbitmq.client.AMQP$BasicProperties", "byte[]"});
                    if (constructor != null) {
                        constructor.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.DeliveryConstructInterceptor", "rabbitmqConsumerScope", ExecutionPolicy.INTERNAL);
                    }
                    if ((constructor_2_1_0 = target.getConstructor(new String[]{"java.lang.String", "com.rabbitmq.client.Envelope", "com.rabbitmq.client.AMQP$BasicProperties", "byte[]", "java.lang.String"})) != null) {
                        constructor_2_1_0.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.DeliveryConstructInterceptor", "rabbitmqConsumerScope", ExecutionPolicy.INTERNAL);
                    }
                    target.addField(AsyncContextAccessor.class.getName());
                    return target.toBytecode();
                }
            });
            this.transformTemplate.transform("org.springframework.amqp.rabbit.listener.BlockingQueueConsumer", new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentMethod handle2;
                    InstrumentMethod handle1;
                    InstrumentMethod nextMessageTimeout;
                    InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                    InstrumentMethod nextMessage = target.getDeclaredMethod("nextMessage", new String[0]);
                    if (nextMessage != null) {
                        nextMessage.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.QueueingConsumerOnNextInterceptor", "rabbitmqConsumerScope");
                    }
                    if ((nextMessageTimeout = target.getDeclaredMethod("nextMessage", new String[]{"long"})) != null) {
                        nextMessageTimeout.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.QueueingConsumerOnNextInterceptor", "rabbitmqConsumerScope");
                    }
                    if ((handle1 = target.getDeclaredMethod("handle", new String[]{"org.springframework.amqp.rabbit.listener.BlockingQueueConsumer$Delivery"})) != null) {
                        handle1.addInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.QueueingConsumerHandleInterceptor");
                    }
                    if ((handle2 = target.getDeclaredMethod("handle", new String[]{"org.springframework.amqp.rabbit.support.Delivery"})) != null) {
                        handle2.addInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.QueueingConsumerHandleInterceptor");
                    }
                    return target.toBytecode();
                }
            });
            this.transformTemplate.transform("org.springframework.amqp.rabbit.listener.BlockingQueueConsumer$InternalConsumer", new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                    if (RabbitMQClientPlugin.this.addConsumerHandleDeliveryInterceptor(target)) {
                        return target.toBytecode();
                    }
                    return null;
                }
            });
            this.transformTemplate.transform("org.springframework.amqp.rabbit.listener.BlockingQueueConsumer$ConsumerDecorator", new TransformCallback(){

                public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                    InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                    if (RabbitMQClientPlugin.this.addConsumerHandleDeliveryInterceptor(target)) {
                        return target.toBytecode();
                    }
                    return null;
                }
            });
        }
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }

    private static class ChannelTransformCallback
    implements TransformCallback {
        private final boolean traceProducer;
        private final boolean traceConsumer;

        private ChannelTransformCallback(boolean traceProducer, boolean traceConsumer) {
            this.traceProducer = traceProducer;
            this.traceConsumer = traceConsumer;
        }

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentMethod basicGet;
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            if (this.traceProducer) {
                target.weave("com.navercorp.pinpoint.plugin.rabbitmq.client.aspect.ChannelAspect");
                InstrumentMethod basicPublish = target.getDeclaredMethod("basicPublish", new String[]{"java.lang.String", "java.lang.String", "boolean", "boolean", "com.rabbitmq.client.AMQP$BasicProperties", "byte[]"});
                if (basicPublish != null) {
                    basicPublish.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.ChannelBasicPublishInterceptor", "rabbitmqProducerScope", ExecutionPolicy.BOUNDARY);
                }
            }
            if (this.traceConsumer && (basicGet = target.getDeclaredMethod("basicGet", new String[]{"java.lang.String", "boolean"})) != null) {
                basicGet.addScopedInterceptor("com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor.ChannelBasicGetInterceptor", "rabbitmqConsumerScope");
            }
            return target.toBytecode();
        }
    }
}

