/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.id;

import com.google.inject.Inject;
import com.navercorp.pinpoint.profiler.context.id.IdGenerator;
import com.navercorp.pinpoint.profiler.context.id.TransactionCounter;

public class DefaultTransactionCounter
implements TransactionCounter {
    private final IdGenerator idGenerator;

    @Inject
    public DefaultTransactionCounter(IdGenerator idGenerator) {
        if (idGenerator == null) {
            throw new NullPointerException("idGenerator");
        }
        this.idGenerator = idGenerator;
    }

    @Override
    public long getSampledNewCount() {
        return this.idGenerator.currentTransactionId() - 1L;
    }

    @Override
    public long getSampledContinuationCount() {
        return Math.abs(this.idGenerator.currentContinuedTransactionId() - -1001L) / 5L;
    }

    @Override
    public long getUnSampledNewCount() {
        return Math.abs(this.idGenerator.currentDisabledId() - -1002L) / 5L;
    }

    @Override
    public long getUnSampledContinuationCount() {
        return Math.abs(this.idGenerator.currentContinuedDisabledId() - -1003L) / 5L;
    }

    @Override
    public long getSkippedNewCount() {
        return Math.abs(this.idGenerator.currentSkippedId() - -1004L) / 5L;
    }

    @Override
    public long getSkippedContinuationCount() {
        return Math.abs(this.idGenerator.currentContinuedSkippedId() - -1005L) / 5L;
    }

    @Override
    public long getTotalTransactionCount() {
        long count = this.getSampledNewCount();
        count += this.getSampledContinuationCount();
        count += this.getUnSampledNewCount();
        count += this.getUnSampledContinuationCount();
        count += this.getSkippedNewCount();
        return count += this.getSkippedContinuationCount();
    }
}

