/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.resolver.condition;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.resolver.condition.Condition;
import com.navercorp.pinpoint.bootstrap.resolver.condition.ConditionValue;
import com.navercorp.pinpoint.common.util.SimpleProperty;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.common.util.SystemProperty;

public class PropertyCondition
implements Condition<String>,
ConditionValue<SimpleProperty> {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass().getName());
    private final SimpleProperty property;

    public PropertyCondition() {
        this(SystemProperty.INSTANCE);
    }

    public PropertyCondition(SimpleProperty property) {
        this.property = property;
    }

    @Override
    public boolean check(String requiredKey) {
        if (StringUtils.isEmpty(requiredKey)) {
            return false;
        }
        if (this.property.getProperty(requiredKey) != null) {
            this.logger.debug("Property '{}' found in [{}]", (Object)requiredKey, (Object)this.property.getClass().getSimpleName());
            return true;
        }
        this.logger.debug("Property '{}' not found in [{}]", (Object)requiredKey, (Object)this.property.getClass().getSimpleName());
        return false;
    }

    @Override
    public SimpleProperty getValue() {
        return this.property;
    }
}

