/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.context.Header;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.util.NumberUtils;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.Assert;

public class ServerRequestRecorder<T> {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final RequestAdaptor<T> requestAdaptor;

    public ServerRequestRecorder(RequestAdaptor<T> requestAdaptor) {
        this.requestAdaptor = Assert.requireNonNull(requestAdaptor, "requestAdaptor must not be null");
    }

    public void record(SpanRecorder recorder, T request) {
        if (recorder == null || request == null) {
            return;
        }
        String rpcName = this.requestAdaptor.getRpcName(request);
        recorder.recordRpcName(rpcName);
        if (this.isDebug) {
            this.logger.debug("Record rpcName={}", (Object)rpcName);
        }
        String endPoint = this.requestAdaptor.getEndPoint(request);
        recorder.recordEndPoint(endPoint);
        if (this.isDebug) {
            this.logger.debug("Record endPoint={}", (Object)endPoint);
        }
        String remoteAddress = this.requestAdaptor.getRemoteAddress(request);
        recorder.recordRemoteAddress(remoteAddress);
        if (this.isDebug) {
            this.logger.debug("Record remoteAddress={}", (Object)remoteAddress);
        }
        if (!recorder.isRoot()) {
            this.recordParentInfo(recorder, request);
        }
    }

    private void recordParentInfo(SpanRecorder recorder, T request) {
        String parentApplicationName = this.requestAdaptor.getHeader(request, Header.HTTP_PARENT_APPLICATION_NAME.toString());
        if (parentApplicationName != null) {
            String host = this.requestAdaptor.getHeader(request, Header.HTTP_HOST.toString());
            if (host == null) {
                host = this.requestAdaptor.getAcceptorHost(request);
            }
            recorder.recordAcceptorHost(host);
            if (this.isDebug) {
                this.logger.debug("Record acceptorHost={}", (Object)host);
            }
            String type = this.requestAdaptor.getHeader(request, Header.HTTP_PARENT_APPLICATION_TYPE.toString());
            short parentApplicationType = NumberUtils.parseShort(type, ServiceType.UNDEFINED.getCode());
            recorder.recordParentApplication(parentApplicationName, parentApplicationType);
            if (this.isDebug) {
                this.logger.debug("Record parentApplicationName={}, parentApplicationType={}", (Object)parentApplicationName, (Object)parentApplicationType);
            }
        } else if (this.isDebug) {
            this.logger.debug("Not found parentApplication");
        }
    }
}

