/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationUtils;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.HierarchicalReloadableConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Lock;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationEvent;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationListener;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.DefaultConfigurationKey;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.DefaultConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.DefaultExpressionEngine;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ExpressionEngine;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.NodeCombiner;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.TreeUtils;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.UnionCombiner;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ViewNode;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedConfiguration
extends HierarchicalReloadableConfiguration
implements ConfigurationListener,
Cloneable {
    public static final int EVENT_COMBINED_INVALIDATE = 40;
    private static final long serialVersionUID = 8338574525528692307L;
    private static final DefaultExpressionEngine AT_ENGINE = new DefaultExpressionEngine();
    private static final NodeCombiner DEFAULT_COMBINER = new UnionCombiner();
    private static final String PROP_RELOAD_CHECK = "CombinedConfigurationReloadCheck";
    private NodeCombiner nodeCombiner;
    private volatile ConfigurationNode combinedRoot;
    private List<ConfigData> configurations;
    private Map<String, AbstractConfiguration> namedConfigurations;
    private boolean ignoreReloadExceptions = true;
    private boolean reloadRequired;
    private ExpressionEngine conversionExpressionEngine;
    private boolean forceReloadCheck;

    public CombinedConfiguration(NodeCombiner nodeCombiner) {
        this.setNodeCombiner(nodeCombiner != null ? nodeCombiner : DEFAULT_COMBINER);
        this.clear();
    }

    public CombinedConfiguration(NodeCombiner nodeCombiner, Lock lock) {
        super(lock);
        this.setNodeCombiner(nodeCombiner != null ? nodeCombiner : DEFAULT_COMBINER);
        this.clear();
    }

    public CombinedConfiguration(Lock lock) {
        this(null, lock);
    }

    public CombinedConfiguration() {
        this(null, null);
    }

    public NodeCombiner getNodeCombiner() {
        return this.nodeCombiner;
    }

    public void setNodeCombiner(NodeCombiner nodeCombiner) {
        if (nodeCombiner == null) {
            throw new IllegalArgumentException("Node combiner must not be null!");
        }
        this.nodeCombiner = nodeCombiner;
        this.invalidate();
    }

    public boolean isForceReloadCheck() {
        return this.forceReloadCheck;
    }

    public void setForceReloadCheck(boolean bl) {
        this.forceReloadCheck = bl;
    }

    public ExpressionEngine getConversionExpressionEngine() {
        return this.conversionExpressionEngine;
    }

    public void setConversionExpressionEngine(ExpressionEngine expressionEngine) {
        this.conversionExpressionEngine = expressionEngine;
    }

    public boolean isIgnoreReloadExceptions() {
        return this.ignoreReloadExceptions;
    }

    public void setIgnoreReloadExceptions(boolean bl) {
        this.ignoreReloadExceptions = bl;
    }

    public void addConfiguration(AbstractConfiguration abstractConfiguration, String string, String string2) {
        if (abstractConfiguration == null) {
            throw new IllegalArgumentException("Added configuration must not be null!");
        }
        if (string != null && this.namedConfigurations.containsKey(string)) {
            throw new ConfigurationRuntimeException("A configuration with the name '" + string + "' already exists in this combined configuration!");
        }
        ConfigData configData = new ConfigData(abstractConfiguration, string, string2);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Adding configuration " + abstractConfiguration + " with name " + string);
        }
        this.configurations.add(configData);
        if (string != null) {
            this.namedConfigurations.put(string, abstractConfiguration);
        }
        abstractConfiguration.addConfigurationListener(this);
        this.invalidate();
    }

    public void addConfiguration(AbstractConfiguration abstractConfiguration, String string) {
        this.addConfiguration(abstractConfiguration, string, null);
    }

    public void addConfiguration(AbstractConfiguration abstractConfiguration) {
        this.addConfiguration(abstractConfiguration, null, null);
    }

    public int getNumberOfConfigurations() {
        return this.configurations.size();
    }

    public Configuration getConfiguration(int n) {
        ConfigData configData = this.configurations.get(n);
        return configData.getConfiguration();
    }

    public Configuration getConfiguration(String string) {
        return this.namedConfigurations.get(string);
    }

    public List<AbstractConfiguration> getConfigurations() {
        ArrayList<AbstractConfiguration> arrayList = new ArrayList<AbstractConfiguration>(this.configurations.size());
        for (ConfigData configData : this.configurations) {
            arrayList.add(configData.getConfiguration());
        }
        return arrayList;
    }

    public List<String> getConfigurationNameList() {
        ArrayList<String> arrayList = new ArrayList<String>(this.configurations.size());
        for (ConfigData configData : this.configurations) {
            arrayList.add(configData.getName());
        }
        return arrayList;
    }

    public boolean removeConfiguration(Configuration configuration) {
        for (int i = 0; i < this.getNumberOfConfigurations(); ++i) {
            if (this.configurations.get(i).getConfiguration() != configuration) continue;
            this.removeConfigurationAt(i);
            return true;
        }
        return false;
    }

    public Configuration removeConfigurationAt(int n) {
        ConfigData configData = this.configurations.remove(n);
        if (configData.getName() != null) {
            this.namedConfigurations.remove(configData.getName());
        }
        configData.getConfiguration().removeConfigurationListener(this);
        this.invalidate();
        return configData.getConfiguration();
    }

    public Configuration removeConfiguration(String string) {
        Configuration configuration = this.getConfiguration(string);
        if (configuration != null) {
            this.removeConfiguration(configuration);
        }
        return configuration;
    }

    public Set<String> getConfigurationNames() {
        return this.namedConfigurations.keySet();
    }

    public void invalidate() {
        this.reloadRequired = true;
        this.fireEvent(40, null, null, false);
    }

    @Override
    public void configurationChanged(ConfigurationEvent configurationEvent) {
        if (configurationEvent.getType() == 21) {
            this.fireEvent(configurationEvent.getType(), configurationEvent.getPropertyName(), configurationEvent.getPropertyValue(), configurationEvent.isBeforeUpdate());
        } else if (!configurationEvent.isBeforeUpdate()) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationNode getRootNode() {
        Object object = this.getReloadLock();
        synchronized (object) {
            if (this.reloadRequired || this.combinedRoot == null) {
                this.combinedRoot = this.constructCombinedNode();
                this.reloadRequired = false;
            }
            return this.combinedRoot;
        }
    }

    @Override
    public void clear() {
        this.fireEvent(4, null, null, true);
        this.configurations = new ArrayList<ConfigData>();
        this.namedConfigurations = new HashMap<String, AbstractConfiguration>();
        this.fireEvent(4, null, null, false);
        this.invalidate();
    }

    @Override
    public Object clone() {
        CombinedConfiguration combinedConfiguration = (CombinedConfiguration)super.clone();
        combinedConfiguration.clear();
        for (ConfigData configData : this.configurations) {
            combinedConfiguration.addConfiguration((AbstractConfiguration)ConfigurationUtils.cloneConfiguration(configData.getConfiguration()), configData.getName(), configData.getAt());
        }
        combinedConfiguration.setRootNode(new DefaultConfigurationNode());
        return combinedConfiguration;
    }

    public Configuration getSource(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Key must not be null!");
        }
        List<ConfigurationNode> list = this.fetchNodeList(string);
        if (list.isEmpty()) {
            return null;
        }
        Iterator<ConfigurationNode> iterator = list.iterator();
        Configuration configuration = this.findSourceConfiguration(iterator.next());
        while (iterator.hasNext()) {
            Configuration configuration2 = this.findSourceConfiguration(iterator.next());
            if (configuration2 == configuration) continue;
            throw new IllegalArgumentException("The key " + string + " is defined by multiple sources!");
        }
        return configuration;
    }

    @Override
    protected List<ConfigurationNode> fetchNodeList(String string) {
        if (this.isForceReloadCheck()) {
            this.performReloadCheck();
        }
        return super.fetchNodeList(string);
    }

    protected void performReloadCheck() {
        for (ConfigData configData : this.configurations) {
            try {
                configData.getConfiguration().getProperty(PROP_RELOAD_CHECK);
            }
            catch (Exception exception) {
                if (this.ignoreReloadExceptions) continue;
                throw new ConfigurationRuntimeException(exception);
            }
        }
    }

    private ConfigurationNode constructCombinedNode() {
        if (this.getNumberOfConfigurations() < 1) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No configurations defined for " + this);
            }
            return new ViewNode();
        }
        Iterator<ConfigData> iterator = this.configurations.iterator();
        ConfigurationNode configurationNode = iterator.next().getTransformedRoot();
        while (iterator.hasNext()) {
            configurationNode = this.getNodeCombiner().combine(configurationNode, iterator.next().getTransformedRoot());
        }
        if (this.getLogger().isDebugEnabled()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            TreeUtils.printTree(printStream, configurationNode);
            this.getLogger().debug(byteArrayOutputStream.toString());
        }
        return configurationNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration findSourceConfiguration(ConfigurationNode configurationNode) {
        Object object = this.getReloadLock();
        synchronized (object) {
            ConfigurationNode configurationNode2 = null;
            for (ConfigurationNode configurationNode3 = configurationNode; configurationNode3 != null; configurationNode3 = configurationNode3.getParentNode()) {
                configurationNode2 = configurationNode3;
            }
            for (ConfigData configData : this.configurations) {
                if (configurationNode2 != configData.getRootNode()) continue;
                return configData.getConfiguration();
            }
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConfigData {
        private AbstractConfiguration configuration;
        private String name;
        private Collection<String> atPath;
        private String at;
        private ConfigurationNode rootNode;

        public ConfigData(AbstractConfiguration abstractConfiguration, String string, String string2) {
            this.configuration = abstractConfiguration;
            this.name = string;
            this.atPath = this.parseAt(string2);
            this.at = string2;
        }

        public AbstractConfiguration getConfiguration() {
            return this.configuration;
        }

        public String getName() {
            return this.name;
        }

        public String getAt() {
            return this.at;
        }

        public ConfigurationNode getRootNode() {
            return this.rootNode;
        }

        public ConfigurationNode getTransformedRoot() {
            ViewNode viewNode;
            ViewNode viewNode2 = viewNode = new ViewNode();
            if (this.atPath != null) {
                for (String string : this.atPath) {
                    ViewNode viewNode3 = new ViewNode();
                    viewNode3.setName(string);
                    viewNode2.addChild(viewNode3);
                    viewNode2 = viewNode3;
                }
            }
            ConfigurationNode configurationNode = ConfigurationUtils.convertToHierarchical(this.getConfiguration(), CombinedConfiguration.this.getConversionExpressionEngine()).getRootNode();
            viewNode2.appendChildren(configurationNode);
            viewNode2.appendAttributes(configurationNode);
            this.rootNode = configurationNode;
            return viewNode;
        }

        private Collection<String> parseAt(String string) {
            if (string == null) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            DefaultConfigurationKey.KeyIterator keyIterator = new DefaultConfigurationKey(AT_ENGINE, string).iterator();
            while (keyIterator.hasNext()) {
                arrayList.add(keyIterator.nextKey());
            }
            return arrayList;
        }
    }
}

