/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.tree;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.DefaultConfigurationKey;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ExpressionEngine;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.NodeAddData;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExpressionEngine
implements ExpressionEngine {
    public static final String DEFAULT_PROPERTY_DELIMITER = ".";
    public static final String DEFAULT_ESCAPED_DELIMITER = "..";
    public static final String DEFAULT_ATTRIBUTE_START = "[@";
    public static final String DEFAULT_ATTRIBUTE_END = "]";
    public static final String DEFAULT_INDEX_START = "(";
    public static final String DEFAULT_INDEX_END = ")";
    private String propertyDelimiter = ".";
    private String escapedDelimiter = "..";
    private String attributeStart = "[@";
    private String attributeEnd = "]";
    private String indexStart = "(";
    private String indexEnd = ")";

    public String getAttributeEnd() {
        return this.attributeEnd;
    }

    public void setAttributeEnd(String string) {
        this.attributeEnd = string;
    }

    public String getAttributeStart() {
        return this.attributeStart;
    }

    public void setAttributeStart(String string) {
        this.attributeStart = string;
    }

    public String getEscapedDelimiter() {
        return this.escapedDelimiter;
    }

    public void setEscapedDelimiter(String string) {
        this.escapedDelimiter = string;
    }

    public String getIndexEnd() {
        return this.indexEnd;
    }

    public void setIndexEnd(String string) {
        this.indexEnd = string;
    }

    public String getIndexStart() {
        return this.indexStart;
    }

    public void setIndexStart(String string) {
        this.indexStart = string;
    }

    public String getPropertyDelimiter() {
        return this.propertyDelimiter;
    }

    public void setPropertyDelimiter(String string) {
        this.propertyDelimiter = string;
    }

    @Override
    public List<ConfigurationNode> query(ConfigurationNode configurationNode, String string) {
        LinkedList<ConfigurationNode> linkedList = new LinkedList<ConfigurationNode>();
        this.findNodesForKey(new DefaultConfigurationKey(this, string).iterator(), configurationNode, linkedList);
        return linkedList;
    }

    @Override
    public String nodeKey(ConfigurationNode configurationNode, String string) {
        if (string == null) {
            return "";
        }
        DefaultConfigurationKey defaultConfigurationKey = new DefaultConfigurationKey(this, string);
        if (configurationNode.isAttribute()) {
            defaultConfigurationKey.appendAttribute(configurationNode.getName());
        } else {
            defaultConfigurationKey.append(configurationNode.getName(), true);
        }
        return defaultConfigurationKey.toString();
    }

    @Override
    public NodeAddData prepareAdd(ConfigurationNode configurationNode, String string) {
        DefaultConfigurationKey.KeyIterator keyIterator = new DefaultConfigurationKey(this, string).iterator();
        if (!keyIterator.hasNext()) {
            throw new IllegalArgumentException("Key for add operation must be defined!");
        }
        NodeAddData nodeAddData = new NodeAddData();
        nodeAddData.setParent(this.findLastPathNode(keyIterator, configurationNode));
        while (keyIterator.hasNext()) {
            if (!keyIterator.isPropertyKey()) {
                throw new IllegalArgumentException("Invalid key for add operation: " + string + " (Attribute key in the middle.)");
            }
            nodeAddData.addPathNode(keyIterator.currentKey());
            keyIterator.next();
        }
        nodeAddData.setNewNodeName(keyIterator.currentKey());
        nodeAddData.setAttribute(!keyIterator.isPropertyKey());
        return nodeAddData;
    }

    protected void findNodesForKey(DefaultConfigurationKey.KeyIterator keyIterator, ConfigurationNode configurationNode, Collection<ConfigurationNode> collection) {
        if (!keyIterator.hasNext()) {
            collection.add(configurationNode);
        } else {
            String string = keyIterator.nextKey(false);
            if (keyIterator.isPropertyKey()) {
                this.processSubNodes(keyIterator, configurationNode.getChildren(string), collection);
            }
            if (keyIterator.isAttribute()) {
                this.processSubNodes(keyIterator, configurationNode.getAttributes(string), collection);
            }
        }
    }

    protected ConfigurationNode findLastPathNode(DefaultConfigurationKey.KeyIterator keyIterator, ConfigurationNode configurationNode) {
        String string = keyIterator.nextKey(false);
        if (keyIterator.hasNext()) {
            int n;
            if (!keyIterator.isPropertyKey()) {
                throw new IllegalArgumentException("Invalid path for add operation: Attribute key in the middle!");
            }
            int n2 = n = keyIterator.hasIndex() ? keyIterator.getIndex() : configurationNode.getChildrenCount(string) - 1;
            if (n < 0 || n >= configurationNode.getChildrenCount(string)) {
                return configurationNode;
            }
            return this.findLastPathNode(keyIterator, configurationNode.getChildren(string).get(n));
        }
        return configurationNode;
    }

    private void processSubNodes(DefaultConfigurationKey.KeyIterator keyIterator, List<ConfigurationNode> list, Collection<ConfigurationNode> collection) {
        if (keyIterator.hasIndex()) {
            if (keyIterator.getIndex() >= 0 && keyIterator.getIndex() < list.size()) {
                this.findNodesForKey((DefaultConfigurationKey.KeyIterator)keyIterator.clone(), list.get(keyIterator.getIndex()), collection);
            }
        } else {
            for (ConfigurationNode configurationNode : list) {
                this.findNodesForKey((DefaultConfigurationKey.KeyIterator)keyIterator.clone(), configurationNode, collection);
            }
        }
    }
}

