/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.lang.text;

import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrBuilder;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrLookup;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrMatcher;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class StrSubstitutor {
    public static final char DEFAULT_ESCAPE = '$';
    public static final StrMatcher DEFAULT_PREFIX = StrMatcher.stringMatcher("${");
    public static final StrMatcher DEFAULT_SUFFIX = StrMatcher.stringMatcher("}");
    private char escapeChar;
    private StrMatcher prefixMatcher;
    private StrMatcher suffixMatcher;
    private StrLookup variableResolver;
    private boolean enableSubstitutionInVariables;

    public static String replace(Object object, Map map) {
        return new StrSubstitutor(map).replace(object);
    }

    public static String replace(Object object, Map map, String string, String string2) {
        return new StrSubstitutor(map, string, string2).replace(object);
    }

    public static String replace(Object object, Properties properties) {
        if (properties == null) {
            return object.toString();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            hashMap.put(string, string2);
        }
        return StrSubstitutor.replace(object, hashMap);
    }

    public static String replaceSystemProperties(Object object) {
        return new StrSubstitutor(StrLookup.systemPropertiesLookup()).replace(object);
    }

    public StrSubstitutor() {
        this((StrLookup)null, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public StrSubstitutor(Map map) {
        this(StrLookup.mapLookup(map), DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public StrSubstitutor(Map map, String string, String string2) {
        this(StrLookup.mapLookup(map), string, string2, '$');
    }

    public StrSubstitutor(Map map, String string, String string2, char c2) {
        this(StrLookup.mapLookup(map), string, string2, c2);
    }

    public StrSubstitutor(StrLookup strLookup) {
        this(strLookup, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public StrSubstitutor(StrLookup strLookup, String string, String string2, char c2) {
        this.setVariableResolver(strLookup);
        this.setVariablePrefix(string);
        this.setVariableSuffix(string2);
        this.setEscapeChar(c2);
    }

    public StrSubstitutor(StrLookup strLookup, StrMatcher strMatcher, StrMatcher strMatcher2, char c2) {
        this.setVariableResolver(strLookup);
        this.setVariablePrefixMatcher(strMatcher);
        this.setVariableSuffixMatcher(strMatcher2);
        this.setEscapeChar(c2);
    }

    public String replace(String string) {
        if (string == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(string);
        if (!this.substitute(strBuilder, 0, string.length())) {
            return string;
        }
        return strBuilder.toString();
    }

    public String replace(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(n2).append(string, n, n2);
        if (!this.substitute(strBuilder, 0, n2)) {
            return string.substring(n, n + n2);
        }
        return strBuilder.toString();
    }

    public String replace(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(cArray.length).append(cArray);
        this.substitute(strBuilder, 0, cArray.length);
        return strBuilder.toString();
    }

    public String replace(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(n2).append(cArray, n, n2);
        this.substitute(strBuilder, 0, n2);
        return strBuilder.toString();
    }

    public String replace(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(stringBuffer.length()).append(stringBuffer);
        this.substitute(strBuilder, 0, strBuilder.length());
        return strBuilder.toString();
    }

    public String replace(StringBuffer stringBuffer, int n, int n2) {
        if (stringBuffer == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(n2).append(stringBuffer, n, n2);
        this.substitute(strBuilder, 0, n2);
        return strBuilder.toString();
    }

    public String replace(StrBuilder strBuilder) {
        if (strBuilder == null) {
            return null;
        }
        StrBuilder strBuilder2 = new StrBuilder(strBuilder.length()).append(strBuilder);
        this.substitute(strBuilder2, 0, strBuilder2.length());
        return strBuilder2.toString();
    }

    public String replace(StrBuilder strBuilder, int n, int n2) {
        if (strBuilder == null) {
            return null;
        }
        StrBuilder strBuilder2 = new StrBuilder(n2).append(strBuilder, n, n2);
        this.substitute(strBuilder2, 0, n2);
        return strBuilder2.toString();
    }

    public String replace(Object object) {
        if (object == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder().append(object);
        this.substitute(strBuilder, 0, strBuilder.length());
        return strBuilder.toString();
    }

    public boolean replaceIn(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return false;
        }
        return this.replaceIn(stringBuffer, 0, stringBuffer.length());
    }

    public boolean replaceIn(StringBuffer stringBuffer, int n, int n2) {
        if (stringBuffer == null) {
            return false;
        }
        StrBuilder strBuilder = new StrBuilder(n2).append(stringBuffer, n, n2);
        if (!this.substitute(strBuilder, 0, n2)) {
            return false;
        }
        stringBuffer.replace(n, n + n2, strBuilder.toString());
        return true;
    }

    public boolean replaceIn(StrBuilder strBuilder) {
        if (strBuilder == null) {
            return false;
        }
        return this.substitute(strBuilder, 0, strBuilder.length());
    }

    public boolean replaceIn(StrBuilder strBuilder, int n, int n2) {
        if (strBuilder == null) {
            return false;
        }
        return this.substitute(strBuilder, n, n2);
    }

    protected boolean substitute(StrBuilder strBuilder, int n, int n2) {
        return this.substitute(strBuilder, n, n2, null) > 0;
    }

    private int substitute(StrBuilder strBuilder, int n, int n2, List arrayList) {
        StrMatcher strMatcher = this.getVariablePrefixMatcher();
        StrMatcher strMatcher2 = this.getVariableSuffixMatcher();
        char c2 = this.getEscapeChar();
        boolean bl = arrayList == null;
        boolean bl2 = false;
        int n3 = 0;
        char[] cArray = strBuilder.buffer;
        int n4 = n + n2;
        int n5 = n;
        block0: while (n5 < n4) {
            int n6 = strMatcher.isMatch(cArray, n5, n, n4);
            if (n6 == 0) {
                ++n5;
                continue;
            }
            if (n5 > n && cArray[n5 - 1] == c2) {
                strBuilder.deleteCharAt(n5 - 1);
                cArray = strBuilder.buffer;
                --n3;
                bl2 = true;
                --n4;
                continue;
            }
            int n7 = n5;
            n5 += n6;
            int n8 = 0;
            int n9 = 0;
            while (n5 < n4) {
                if (this.isEnableSubstitutionInVariables() && (n8 = strMatcher.isMatch(cArray, n5, n, n4)) != 0) {
                    ++n9;
                    n5 += n8;
                    continue;
                }
                n8 = strMatcher2.isMatch(cArray, n5, n, n4);
                if (n8 == 0) {
                    ++n5;
                    continue;
                }
                if (n9 == 0) {
                    String string = new String(cArray, n7 + n6, n5 - n7 - n6);
                    if (this.isEnableSubstitutionInVariables()) {
                        StrBuilder strBuilder2 = new StrBuilder(string);
                        this.substitute(strBuilder2, 0, strBuilder2.length());
                        string = strBuilder2.toString();
                    }
                    int n10 = n5 += n8;
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                        arrayList.add(new String(cArray, n, n2));
                    }
                    this.checkCyclicSubstitution(string, arrayList);
                    arrayList.add(string);
                    String string2 = this.resolveVariable(string, strBuilder, n7, n10);
                    if (string2 != null) {
                        int n11 = string2.length();
                        strBuilder.replace(n7, n10, string2);
                        bl2 = true;
                        int n12 = this.substitute(strBuilder, n7, n11, arrayList);
                        n5 += (n12 += n11 - (n10 - n7));
                        n4 += n12;
                        n3 += n12;
                        cArray = strBuilder.buffer;
                    }
                    arrayList.remove(arrayList.size() - 1);
                    continue block0;
                }
                --n9;
                n5 += n8;
            }
        }
        if (bl) {
            return bl2 ? 1 : 0;
        }
        return n3;
    }

    private void checkCyclicSubstitution(String string, List list) {
        if (!list.contains(string)) {
            return;
        }
        StrBuilder strBuilder = new StrBuilder(256);
        strBuilder.append("Infinite loop in property interpolation of ");
        strBuilder.append(list.remove(0));
        strBuilder.append(": ");
        strBuilder.appendWithSeparators(list, "->");
        throw new IllegalStateException(strBuilder.toString());
    }

    protected String resolveVariable(String string, StrBuilder strBuilder, int n, int n2) {
        StrLookup strLookup = this.getVariableResolver();
        if (strLookup == null) {
            return null;
        }
        return strLookup.lookup(string);
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char c2) {
        this.escapeChar = c2;
    }

    public StrMatcher getVariablePrefixMatcher() {
        return this.prefixMatcher;
    }

    public StrSubstitutor setVariablePrefixMatcher(StrMatcher strMatcher) {
        if (strMatcher == null) {
            throw new IllegalArgumentException("Variable prefix matcher must not be null!");
        }
        this.prefixMatcher = strMatcher;
        return this;
    }

    public StrSubstitutor setVariablePrefix(char c2) {
        return this.setVariablePrefixMatcher(StrMatcher.charMatcher(c2));
    }

    public StrSubstitutor setVariablePrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Variable prefix must not be null!");
        }
        return this.setVariablePrefixMatcher(StrMatcher.stringMatcher(string));
    }

    public StrMatcher getVariableSuffixMatcher() {
        return this.suffixMatcher;
    }

    public StrSubstitutor setVariableSuffixMatcher(StrMatcher strMatcher) {
        if (strMatcher == null) {
            throw new IllegalArgumentException("Variable suffix matcher must not be null!");
        }
        this.suffixMatcher = strMatcher;
        return this;
    }

    public StrSubstitutor setVariableSuffix(char c2) {
        return this.setVariableSuffixMatcher(StrMatcher.charMatcher(c2));
    }

    public StrSubstitutor setVariableSuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Variable suffix must not be null!");
        }
        return this.setVariableSuffixMatcher(StrMatcher.stringMatcher(string));
    }

    public StrLookup getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(StrLookup strLookup) {
        this.variableResolver = strLookup;
    }

    public boolean isEnableSubstitutionInVariables() {
        return this.enableSubstitutionInVariables;
    }

    public void setEnableSubstitutionInVariables(boolean bl) {
        this.enableSubstitutionInVariables = bl;
    }
}

