/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.lang.text;

import java.util.Map;

public abstract class StrLookup {
    private static final StrLookup NONE_LOOKUP = new MapStrLookup(null);
    private static final StrLookup SYSTEM_PROPERTIES_LOOKUP;

    public static StrLookup noneLookup() {
        return NONE_LOOKUP;
    }

    public static StrLookup systemPropertiesLookup() {
        return SYSTEM_PROPERTIES_LOOKUP;
    }

    public static StrLookup mapLookup(Map map) {
        return new MapStrLookup(map);
    }

    protected StrLookup() {
    }

    public abstract String lookup(String var1);

    static {
        StrLookup strLookup = null;
        try {
            strLookup = new MapStrLookup(System.getProperties());
        }
        catch (SecurityException securityException) {
            strLookup = NONE_LOOKUP;
        }
        SYSTEM_PROPERTIES_LOOKUP = strLookup;
    }

    static class MapStrLookup
    extends StrLookup {
        private final Map map;

        MapStrLookup(Map map) {
            this.map = map;
        }

        public String lookup(String string) {
            if (this.map == null) {
                return null;
            }
            Object v = this.map.get(string);
            if (v == null) {
                return null;
            }
            return v.toString();
        }
    }
}

