/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.tree;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNodeVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurationNode
implements ConfigurationNode,
Cloneable {
    private SubNodes children;
    private SubNodes attributes;
    private ConfigurationNode parent;
    private Object value;
    private Object reference;
    private String name;
    private boolean attribute;

    public DefaultConfigurationNode() {
        this(null);
    }

    public DefaultConfigurationNode(String string) {
        this(string, null);
    }

    public DefaultConfigurationNode(String string, Object object) {
        this.setName(string);
        this.setValue(object);
        this.initSubNodes();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.checkState();
        this.name = string;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object object) {
        this.value = object;
    }

    @Override
    public Object getReference() {
        return this.reference;
    }

    @Override
    public void setReference(Object object) {
        this.reference = object;
    }

    @Override
    public ConfigurationNode getParentNode() {
        return this.parent;
    }

    @Override
    public void setParentNode(ConfigurationNode configurationNode) {
        this.parent = configurationNode;
    }

    @Override
    public void addChild(ConfigurationNode configurationNode) {
        this.children.addNode(configurationNode);
        configurationNode.setAttribute(false);
        configurationNode.setParentNode(this);
    }

    @Override
    public List<ConfigurationNode> getChildren() {
        return this.children.getSubNodes();
    }

    @Override
    public int getChildrenCount() {
        return this.children.getSubNodes().size();
    }

    @Override
    public List<ConfigurationNode> getChildren(String string) {
        return this.children.getSubNodes(string);
    }

    @Override
    public int getChildrenCount(String string) {
        return this.children.getSubNodes(string).size();
    }

    @Override
    public ConfigurationNode getChild(int n) {
        return this.children.getNode(n);
    }

    @Override
    public boolean removeChild(ConfigurationNode configurationNode) {
        return this.children.removeNode(configurationNode);
    }

    @Override
    public boolean removeChild(String string) {
        return this.children.removeNodes(string);
    }

    @Override
    public void removeChildren() {
        this.children.clear();
    }

    @Override
    public boolean isAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(boolean bl) {
        this.checkState();
        this.attribute = bl;
    }

    @Override
    public void addAttribute(ConfigurationNode configurationNode) {
        this.attributes.addNode(configurationNode);
        configurationNode.setAttribute(true);
        configurationNode.setParentNode(this);
    }

    @Override
    public List<ConfigurationNode> getAttributes() {
        return this.attributes.getSubNodes();
    }

    @Override
    public int getAttributeCount() {
        return this.attributes.getSubNodes().size();
    }

    @Override
    public List<ConfigurationNode> getAttributes(String string) {
        return this.attributes.getSubNodes(string);
    }

    @Override
    public int getAttributeCount(String string) {
        return this.getAttributes(string).size();
    }

    @Override
    public boolean removeAttribute(ConfigurationNode configurationNode) {
        return this.attributes.removeNode(configurationNode);
    }

    @Override
    public boolean removeAttribute(String string) {
        return this.attributes.removeNodes(string);
    }

    @Override
    public ConfigurationNode getAttribute(int n) {
        return this.attributes.getNode(n);
    }

    @Override
    public void removeAttributes() {
        this.attributes.clear();
    }

    @Override
    public boolean isDefined() {
        return this.getValue() != null || this.getChildrenCount() > 0 || this.getAttributeCount() > 0;
    }

    @Override
    public void visit(ConfigurationNodeVisitor configurationNodeVisitor) {
        if (configurationNodeVisitor == null) {
            throw new IllegalArgumentException("Visitor must not be null!");
        }
        if (!configurationNodeVisitor.terminate()) {
            configurationNodeVisitor.visitBeforeChildren(this);
            this.children.visit(configurationNodeVisitor);
            this.attributes.visit(configurationNodeVisitor);
            configurationNodeVisitor.visitAfterChildren(this);
        }
    }

    @Override
    public Object clone() {
        try {
            DefaultConfigurationNode defaultConfigurationNode = (DefaultConfigurationNode)super.clone();
            defaultConfigurationNode.initSubNodes();
            return defaultConfigurationNode;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ConfigurationRuntimeException("Cannot clone " + this.getClass());
        }
    }

    protected void checkState() {
        if (this.getParentNode() != null) {
            throw new IllegalStateException("Node cannot be modified when added to a parent!");
        }
    }

    protected SubNodes createSubNodes(boolean bl) {
        return new SubNodes();
    }

    protected void removeReference() {
    }

    private void initSubNodes() {
        this.children = this.createSubNodes(false);
        this.attributes = this.createSubNodes(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SubNodes {
        private List<ConfigurationNode> nodes;
        private Map<String, List<ConfigurationNode>> namedNodes;

        protected SubNodes() {
        }

        public void addNode(ConfigurationNode configurationNode) {
            if (configurationNode == null || configurationNode.getName() == null) {
                throw new IllegalArgumentException("Node to add must have a defined name!");
            }
            configurationNode.setParentNode(null);
            if (this.nodes == null) {
                this.nodes = new ArrayList<ConfigurationNode>();
                this.namedNodes = new HashMap<String, List<ConfigurationNode>>();
            }
            this.nodes.add(configurationNode);
            List<ConfigurationNode> list = this.namedNodes.get(configurationNode.getName());
            if (list == null) {
                list = new LinkedList<ConfigurationNode>();
                this.namedNodes.put(configurationNode.getName(), list);
            }
            list.add(configurationNode);
        }

        public boolean removeNode(ConfigurationNode configurationNode) {
            if (this.nodes != null && configurationNode != null && this.nodes.contains(configurationNode)) {
                this.detachNode(configurationNode);
                this.nodes.remove(configurationNode);
                List<ConfigurationNode> list = this.namedNodes.get(configurationNode.getName());
                if (list != null) {
                    list.remove(configurationNode);
                    if (list.isEmpty()) {
                        this.namedNodes.remove(configurationNode.getName());
                    }
                }
                return true;
            }
            return false;
        }

        public boolean removeNodes(String string) {
            List<ConfigurationNode> list;
            if (this.nodes != null && string != null && (list = this.namedNodes.remove(string)) != null) {
                this.detachNodes(list);
                this.nodes.removeAll(list);
                return true;
            }
            return false;
        }

        public void clear() {
            if (this.nodes != null) {
                this.detachNodes(this.nodes);
                this.nodes = null;
                this.namedNodes = null;
            }
        }

        public ConfigurationNode getNode(int n) {
            if (this.nodes == null) {
                throw new IndexOutOfBoundsException("No sub nodes available!");
            }
            return this.nodes.get(n);
        }

        public List<ConfigurationNode> getSubNodes() {
            if (this.nodes == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.nodes);
        }

        public List<ConfigurationNode> getSubNodes(String string) {
            if (string == null) {
                return this.getSubNodes();
            }
            List<ConfigurationNode> list = this.nodes == null ? null : this.namedNodes.get(string);
            if (list == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(list);
        }

        public void visit(ConfigurationNodeVisitor configurationNodeVisitor) {
            if (this.nodes != null) {
                Iterator<ConfigurationNode> iterator = this.nodes.iterator();
                while (iterator.hasNext() && !configurationNodeVisitor.terminate()) {
                    iterator.next().visit(configurationNodeVisitor);
                }
            }
        }

        protected void detachNode(ConfigurationNode configurationNode) {
            configurationNode.setParentNode(null);
            if (configurationNode instanceof DefaultConfigurationNode) {
                ((DefaultConfigurationNode)configurationNode).removeReference();
            }
        }

        protected void detachNodes(Collection<? extends ConfigurationNode> collection) {
            for (ConfigurationNode configurationNode : collection) {
                this.detachNode(configurationNode);
            }
        }
    }
}

